/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.compat.log;

import net.spy.memcached.compat.log.AbstractLogger;
import net.spy.memcached.compat.log.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Log4JLogger
extends AbstractLogger {
    private final Logger l4jLogger;

    public Log4JLogger(String name) {
        super(name);
        this.l4jLogger = LogManager.getLogger((String)name);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.l4jLogger.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.l4jLogger.isDebugEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.l4jLogger.isInfoEnabled();
    }

    @Override
    public void log(Level level, Object message, Throwable e) {
        org.apache.logging.log4j.Level pLevel = org.apache.logging.log4j.Level.DEBUG;
        switch (level == null ? Level.FATAL : level) {
            case TRACE: {
                pLevel = org.apache.logging.log4j.Level.TRACE;
                break;
            }
            case DEBUG: {
                pLevel = org.apache.logging.log4j.Level.DEBUG;
                break;
            }
            case INFO: {
                pLevel = org.apache.logging.log4j.Level.INFO;
                break;
            }
            case WARN: {
                pLevel = org.apache.logging.log4j.Level.WARN;
                break;
            }
            case ERROR: {
                pLevel = org.apache.logging.log4j.Level.ERROR;
                break;
            }
            case FATAL: {
                pLevel = org.apache.logging.log4j.Level.FATAL;
                break;
            }
            default: {
                pLevel = org.apache.logging.log4j.Level.FATAL;
                String logMessage = String.format("Unhandled log level: %s for the following message", new Object[]{level});
                this.l4jLogger.log(pLevel, logMessage, (Throwable)null);
            }
        }
        this.l4jLogger.log(pLevel, message, e);
    }
}

