/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.kll;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.IdentityHashMap;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.DefaultMemoryRequestServer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

abstract class KllSketchMergeBufferAggregatorHelper<SketchType extends KllSketch> {
    private static final MemoryRequestServer MEM_REQ_SERVER = new DefaultMemoryRequestServer();
    private final int k;
    private final int maxIntermediateSize;
    private final IdentityHashMap<ByteBuffer, WritableMemory> memCache = new IdentityHashMap();
    private final IdentityHashMap<ByteBuffer, Int2ObjectMap<SketchType>> unions = new IdentityHashMap();

    KllSketchMergeBufferAggregatorHelper(int k, int maxIntermediateSize) {
        this.k = k;
        this.maxIntermediateSize = maxIntermediateSize;
    }

    public void init(ByteBuffer buffer, int position) {
        WritableMemory mem = this.getMemory(buffer);
        WritableMemory region = mem.writableRegion((long)position, (long)this.maxIntermediateSize);
        SketchType union = this.newDirectInstance(this.k, region, MEM_REQ_SERVER);
        this.putUnion(buffer, position, union);
    }

    public void clear() {
        this.unions.clear();
        this.memCache.clear();
    }

    public void relocate(int oldPosition, int newPosition, ByteBuffer oldBuffer, ByteBuffer newBuffer) {
        WritableMemory oldMem;
        Object union = (KllSketch)this.unions.get(oldBuffer).get(oldPosition);
        if (union.isSameResource((Memory)(oldMem = this.getMemory(oldBuffer).writableRegion((long)oldPosition, (long)this.maxIntermediateSize)))) {
            WritableMemory newMem = this.getMemory(newBuffer).writableRegion((long)newPosition, (long)this.maxIntermediateSize);
            union = this.writableWrap(newMem, MEM_REQ_SERVER);
        }
        this.putUnion(newBuffer, newPosition, union);
        Int2ObjectMap<SketchType> map = this.unions.get(oldBuffer);
        map.remove(oldPosition);
        if (map.isEmpty()) {
            this.unions.remove(oldBuffer);
            this.memCache.remove(oldBuffer);
        }
    }

    public SketchType getSketchAtPosition(ByteBuffer buf, int position) {
        return (SketchType)((KllSketch)this.unions.get(buf).get(position));
    }

    private WritableMemory getMemory(ByteBuffer buffer) {
        return this.memCache.computeIfAbsent(buffer, buf -> WritableMemory.writableWrap((ByteBuffer)buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryRequestServer)MEM_REQ_SERVER));
    }

    private void putUnion(ByteBuffer buffer, int position, SketchType union) {
        Int2ObjectMap map = this.unions.computeIfAbsent(buffer, buf -> new Int2ObjectOpenHashMap());
        map.put(position, union);
    }

    abstract SketchType newDirectInstance(int var1, WritableMemory var2, MemoryRequestServer var3);

    abstract SketchType writableWrap(WritableMemory var1, MemoryRequestServer var2);

    abstract SketchType get(ByteBuffer var1, int var2);
}

