/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.kerberos.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;

public class DruidKerberosAuthenticationHandler
extends KerberosAuthenticationHandler {
    private static final Logger log = new Logger(DruidKerberosAuthenticationHandler.class);
    private String keytab;
    private GSSManager gssManager;
    private Subject serverSubject = new Subject();
    private List<LoginContext> loginContexts = new ArrayList<LoginContext>();

    public void destroy() {
        this.keytab = null;
        this.serverSubject = null;
        for (LoginContext loginContext : this.loginContexts) {
            try {
                loginContext.logout();
            }
            catch (LoginException ex) {
                log.warn((Throwable)ex, ex.getMessage(), new Object[0]);
            }
        }
        this.loginContexts.clear();
    }

    public void init(Properties config) throws ServletException {
        try {
            String nameRules;
            String[] spnegoPrincipals;
            String principal = config.getProperty("kerberos.principal");
            if (principal == null || principal.trim().length() == 0) {
                throw new ServletException("Principal not defined in configuration");
            }
            this.keytab = config.getProperty("kerberos.keytab", this.keytab);
            if (this.keytab == null || this.keytab.trim().length() == 0) {
                throw new ServletException("Keytab not defined in configuration");
            }
            if (!new File(this.keytab).exists()) {
                throw new ServletException("Keytab does not exist: " + this.keytab);
            }
            if ("*".equals(principal)) {
                spnegoPrincipals = KerberosUtil.getPrincipalNames((String)this.keytab, (Pattern)Pattern.compile("HTTP/.*"));
                if (spnegoPrincipals.length == 0) {
                    throw new ServletException("Principals do not exist in the keytab");
                }
            } else {
                spnegoPrincipals = new String[]{principal};
            }
            if ((nameRules = config.getProperty("kerberos.name.rules", null)) != null) {
                KerberosName.setRules((String)nameRules);
            }
            for (String spnegoPrincipal : spnegoPrincipals) {
                log.info("Login using keytab %s, for principal %s", new Object[]{this.keytab, spnegoPrincipal});
                KerberosAuthenticator.DruidKerberosConfiguration kerberosConfiguration = new KerberosAuthenticator.DruidKerberosConfiguration(this.keytab, spnegoPrincipal);
                LoginContext loginContext = new LoginContext("", this.serverSubject, null, kerberosConfiguration);
                try {
                    loginContext.login();
                }
                catch (LoginException le) {
                    log.warn((Throwable)le, "Failed to login as [%s]", new Object[]{spnegoPrincipal});
                    throw new AuthenticationException((Throwable)le);
                }
                this.loginContexts.add(loginContext);
            }
            try {
                this.gssManager = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<GSSManager>(){

                    @Override
                    public GSSManager run() {
                        return GSSManager.getInstance();
                    }
                });
            }
            catch (PrivilegedActionException ex) {
                throw ex.getException();
            }
        }
        catch (Exception ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public AuthenticationToken authenticate(HttpServletRequest request, final HttpServletResponse response) throws IOException, AuthenticationException {
        AuthenticationToken token;
        String authorization = request.getHeader("Authorization");
        if (authorization == null || !authorization.startsWith("Negotiate")) {
            return null;
        }
        authorization = authorization.substring("Negotiate".length()).trim();
        final byte[] clientToken = StringUtils.decodeBase64String((String)authorization);
        final String serverName = request.getServerName();
        try {
            token = Subject.doAs(this.serverSubject, new PrivilegedExceptionAction<AuthenticationToken>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public AuthenticationToken run() throws Exception {
                    AuthenticationToken token = null;
                    GSSContext gssContext = null;
                    GSSCredential gssCreds = null;
                    try {
                        gssCreds = DruidKerberosAuthenticationHandler.this.gssManager.createCredential(DruidKerberosAuthenticationHandler.this.gssManager.createName(KerberosUtil.getServicePrincipal((String)"HTTP", (String)serverName), KerberosUtil.getOidInstance((String)"NT_GSS_KRB5_PRINCIPAL")), Integer.MAX_VALUE, new Oid[]{KerberosUtil.getOidInstance((String)"GSS_SPNEGO_MECH_OID"), KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID")}, 2);
                        gssContext = DruidKerberosAuthenticationHandler.this.gssManager.createContext(gssCreds);
                        byte[] serverToken = gssContext.acceptSecContext(clientToken, 0, clientToken.length);
                        if (serverToken != null && serverToken.length > 0) {
                            String authenticate = StringUtils.encodeBase64String((byte[])serverToken);
                            response.setHeader("WWW-Authenticate", "Negotiate " + authenticate);
                        }
                        if (!gssContext.isEstablished()) {
                            response.setStatus(401);
                            log.trace("SPNEGO in progress", new Object[0]);
                        } else {
                            String clientPrincipal = gssContext.getSrcName().toString();
                            KerberosName kerberosName = new KerberosName(clientPrincipal);
                            String userName = kerberosName.getShortName();
                            token = new AuthenticationToken(userName, clientPrincipal, DruidKerberosAuthenticationHandler.this.getType());
                            response.setStatus(200);
                            log.trace("SPNEGO completed for principal [%s]", new Object[]{clientPrincipal});
                        }
                    }
                    finally {
                        if (gssContext != null) {
                            gssContext.dispose();
                        }
                        if (gssCreds != null) {
                            gssCreds.dispose();
                        }
                    }
                    return token;
                }
            });
        }
        catch (PrivilegedActionException ex) {
            if (ex.getException() instanceof IOException) {
                throw (IOException)ex.getException();
            }
            throw new AuthenticationException((Throwable)ex.getException());
        }
        return token;
    }
}

