/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.kerberos;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.kerberos.DruidKerberosModule;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class DruidKerberosUtil {
    private static final Logger log = new Logger(DruidKerberosUtil.class);
    private static ReentrantLock kerberosLock = new ReentrantLock(true);

    public static String kerberosChallenge(String server) throws AuthenticationException {
        kerberosLock.lock();
        try {
            Oid mechOid = KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID");
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gssContext = manager.createContext(serverName.canonicalize(mechOid), mechOid, null, 0);
            gssContext.requestMutualAuth(true);
            gssContext.requestCredDeleg(true);
            byte[] inToken = new byte[]{};
            byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
            gssContext.dispose();
            String string = new String(StringUtils.encodeBase64((byte[])outToken), StandardCharsets.US_ASCII);
            return string;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | GSSException e) {
            throw new AuthenticationException((Throwable)e);
        }
        finally {
            kerberosLock.unlock();
        }
    }

    public static void authenticateIfRequired(String internalClientPrincipal, String internalClientKeytab) {
        if (!Strings.isNullOrEmpty((String)internalClientPrincipal) && !Strings.isNullOrEmpty((String)internalClientKeytab)) {
            Configuration conf = new Configuration();
            conf.setClassLoader(DruidKerberosModule.class.getClassLoader());
            conf.set("hadoop.security.authentication", "kerberos");
            UserGroupInformation.setConfiguration((Configuration)conf);
            try {
                if (!UserGroupInformation.getCurrentUser().hasKerberosCredentials() || !UserGroupInformation.getCurrentUser().getUserName().equals(internalClientPrincipal)) {
                    log.info("trying to authenticate user [%s] with keytab [%s]", new Object[]{internalClientPrincipal, internalClientKeytab});
                    UserGroupInformation.loginUserFromKeytab((String)internalClientPrincipal, (String)internalClientKeytab);
                    return;
                }
                if (UserGroupInformation.isLoginKeytabBased()) {
                    log.info("Re-Login from key tab [%s] with principal [%s]", new Object[]{internalClientKeytab, internalClientPrincipal});
                    UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
                    return;
                }
                if (UserGroupInformation.isLoginTicketBased()) {
                    log.info("Re-Login from Ticket cache", new Object[0]);
                    UserGroupInformation.getLoginUser().reloginFromTicketCache();
                    return;
                }
            }
            catch (IOException e) {
                throw new ISE((Throwable)e, "Failed to authenticate user principal [%s] with keytab [%s]", new Object[]{internalClientPrincipal, internalClientKeytab});
            }
        }
    }

    public static boolean needToSendCredentials(CookieStore cookieStore, URI uri) {
        return DruidKerberosUtil.getAuthCookie(cookieStore, uri) == null;
    }

    public static HttpCookie getAuthCookie(CookieStore cookieStore, URI uri) {
        if (cookieStore == null) {
            return null;
        }
        boolean isSSL = "https".equals(uri.getScheme());
        List<HttpCookie> cookies = cookieStore.get(uri);
        for (HttpCookie c : cookies) {
            if (c.getSecure() && !isSSL || !c.getName().equals("hadoop.auth")) continue;
            return c;
        }
        return null;
    }

    public static void removeAuthCookie(CookieStore cookieStore, URI uri) {
        HttpCookie authCookie = DruidKerberosUtil.getAuthCookie(cookieStore, uri);
        if (authCookie != null) {
            cookieStore.remove(uri, authCookie);
        }
    }
}

