/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.annotations.restrictions;

import com.github.rvesse.airline.restrictions.common.PortRange;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public enum PortType implements PortRange
{
    ANY(0, 65535),
    OS_ALLOCATED(0, 0),
    SYSTEM(1, 1023),
    USER(1024, 49151),
    DYNAMIC(49152, 65535);

    private final int min;
    private final int max;

    private PortType(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public int getMinimumPort() {
        return this.min;
    }

    @Override
    public int getMaximumPort() {
        return this.max;
    }

    @Override
    public boolean inRange(int port) {
        return port >= this.min && port <= this.max;
    }

    @Override
    public boolean contains(PortRange other) {
        if (this == other) {
            return true;
        }
        return this.getMinimumPort() <= other.getMinimumPort() && this.getMaximumPort() >= other.getMaximumPort();
    }

    public String toString() {
        if (this.min != this.max) {
            return String.format("%d-%d", this.min, this.max);
        }
        return Integer.toString(this.min);
    }

    public static String toRangesString(Set<PortRange> acceptablePorts) {
        StringBuilder builder = new StringBuilder();
        Iterator<PortRange> iter = acceptablePorts.iterator();
        TreeSet<PortRange> types = new TreeSet<PortRange>();
        while (iter.hasNext()) {
            PortRange range = iter.next();
            boolean add = true;
            for (PortRange other : types) {
                if (!other.contains(range)) continue;
                add = false;
                break;
            }
            if (!add) continue;
            types.add(range);
        }
        iter = types.iterator();
        while (iter.hasNext()) {
            builder.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

