/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.Channels;
import com.github.rvesse.airline.help.GlobalUsageGenerator;
import com.github.rvesse.airline.help.UsageHelper;
import com.github.rvesse.airline.help.common.AbstractUsageGenerator;
import com.github.rvesse.airline.help.sections.HelpHint;
import com.github.rvesse.airline.help.sections.HelpSection;
import com.github.rvesse.airline.model.CommandGroupMetadata;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.GlobalMetadata;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.utils.comparators.HelpSectionComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractGlobalUsageGenerator<T>
extends AbstractUsageGenerator
implements GlobalUsageGenerator<T> {
    private final Comparator<? super CommandGroupMetadata> commandGroupComparator;

    public AbstractGlobalUsageGenerator() {
        this(UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, false);
    }

    public AbstractGlobalUsageGenerator(boolean includeHidden) {
        this(UsageHelper.DEFAULT_HINT_COMPARATOR, UsageHelper.DEFAULT_OPTION_COMPARATOR, UsageHelper.DEFAULT_COMMAND_COMPARATOR, UsageHelper.DEFAULT_COMMAND_GROUP_COMPARATOR, includeHidden);
    }

    public AbstractGlobalUsageGenerator(Comparator<? super HelpHint> hintComparator, Comparator<? super OptionMetadata> optionComparator, Comparator<? super CommandMetadata> commandComparator, Comparator<? super CommandGroupMetadata> commandGroupComparator, boolean includeHidden) {
        super(hintComparator, optionComparator, commandComparator, includeHidden);
        this.commandGroupComparator = commandGroupComparator;
    }

    @Override
    public void usage(GlobalMetadata<T> global) throws IOException {
        this.usage(global, Channels.output());
    }

    protected List<CommandGroupMetadata> sortCommandGroups(List<CommandGroupMetadata> groups) {
        if (this.commandGroupComparator != null) {
            groups = new ArrayList<CommandGroupMetadata>(groups);
            Collections.sort(groups, this.commandGroupComparator);
        }
        return groups;
    }

    protected void findHelpSections(GlobalMetadata<T> global, List<HelpSection> preSections, List<HelpSection> postSections) {
        for (HelpSection section : global.getBaseHelpSections()) {
            if (section.suggestedOrder() < 0) {
                preSections.add(section);
                continue;
            }
            postSections.add(section);
        }
        HelpSectionComparator comparator = new HelpSectionComparator();
        Collections.sort(preSections, comparator);
        Collections.sort(postSections, comparator);
    }
}

