/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.help.common;

import com.github.rvesse.airline.help.common.AbstractCommandUsageGenerator;
import com.github.rvesse.airline.io.printers.UsagePrinter;
import com.github.rvesse.airline.model.CommandMetadata;
import com.github.rvesse.airline.model.MetadataLoader;
import com.github.rvesse.airline.model.OptionMetadata;
import com.github.rvesse.airline.model.ParserMetadata;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Comparator;

public abstract class AbstractPrintedCommandUsageGenerator
extends AbstractCommandUsageGenerator {
    private final int columnSize;

    public AbstractPrintedCommandUsageGenerator(int columns, Comparator<? super OptionMetadata> optionComparator, boolean includeHidden) {
        super(optionComparator, includeHidden);
        if (columns <= 0) {
            throw new IllegalArgumentException("columns must be greater than 0");
        }
        this.columnSize = columns;
    }

    public abstract <T> void usage(String var1, String[] var2, String var3, CommandMetadata var4, ParserMetadata<T> var5, UsagePrinter var6) throws IOException;

    protected UsagePrinter createUsagePrinter(OutputStream out) {
        if (out == null) {
            throw new NullPointerException("out cannot be null");
        }
        return new UsagePrinter(new PrintWriter(out), this.columnSize);
    }

    @Override
    public <T> void usage(String programName, String[] groupNames, String commandName, CommandMetadata command, ParserMetadata<T> parserConfig, OutputStream out) throws IOException {
        UsagePrinter printer = this.createUsagePrinter(out);
        if (parserConfig == null) {
            parserConfig = MetadataLoader.loadParser(command.getType());
        }
        this.usage(programName, groupNames, commandName, command, parserConfig, printer);
        printer.flush();
    }
}

