/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.metadata.PasswordProvider;

public class S3InputSourceConfig {
    private final String assumeRoleArn;
    private final String assumeRoleExternalId;
    private final PasswordProvider accessKeyId;
    private final PasswordProvider secretAccessKey;

    @JsonCreator
    public S3InputSourceConfig(@JsonProperty(value="accessKeyId") @Nullable PasswordProvider accessKeyId, @JsonProperty(value="secretAccessKey") @Nullable PasswordProvider secretAccessKey, @JsonProperty(value="assumeRoleArn") @Nullable String assumeRoleArn, @JsonProperty(value="assumeRoleExternalId") @Nullable String assumeRoleExternalId) {
        this.assumeRoleArn = assumeRoleArn;
        this.assumeRoleExternalId = assumeRoleExternalId;
        if (accessKeyId != null || secretAccessKey != null) {
            this.accessKeyId = (PasswordProvider)Preconditions.checkNotNull((Object)accessKeyId, (Object)"accessKeyId cannot be null if secretAccessKey is given");
            this.secretAccessKey = (PasswordProvider)Preconditions.checkNotNull((Object)secretAccessKey, (Object)"secretAccessKey cannot be null if accessKeyId is given");
        } else {
            this.accessKeyId = null;
            this.secretAccessKey = null;
        }
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAssumeRoleArn() {
        return this.assumeRoleArn;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getAssumeRoleExternalId() {
        return this.assumeRoleExternalId;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PasswordProvider getAccessKeyId() {
        return this.accessKeyId;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PasswordProvider getSecretAccessKey() {
        return this.secretAccessKey;
    }

    @JsonIgnore
    public boolean isCredentialsConfigured() {
        return this.accessKeyId != null && this.secretAccessKey != null;
    }

    public String toString() {
        return "S3InputSourceConfig{accessKeyId=" + String.valueOf(this.accessKeyId) + ", secretAccessKey=" + String.valueOf(this.secretAccessKey) + ", assumeRoleArn=" + this.assumeRoleArn + ", assumeRoleExternalId=" + this.assumeRoleExternalId + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3InputSourceConfig that = (S3InputSourceConfig)o;
        return Objects.equals(this.accessKeyId, that.accessKeyId) && Objects.equals(this.secretAccessKey, that.secretAccessKey) && Objects.equals(this.assumeRoleArn, that.assumeRoleArn) && Objects.equals(this.assumeRoleExternalId, that.assumeRoleExternalId);
    }

    public int hashCode() {
        return Objects.hash(this.accessKeyId, this.secretAccessKey, this.assumeRoleArn, this.assumeRoleExternalId);
    }
}

