/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchSortedView;

final class KolmogorovSmirnov {
    KolmogorovSmirnov() {
    }

    public static double computeKSDelta(DoublesSketch sketch1, DoublesSketch sketch2) {
        DoublesSketchSortedView p = new DoublesSketchSortedView(sketch1);
        DoublesSketchSortedView q = new DoublesSketchSortedView(sketch2);
        double[] pSamplesArr = p.getQuantiles();
        double[] qSamplesArr = q.getQuantiles();
        long[] pCumWtsArr = p.getCumulativeWeights();
        long[] qCumWtsArr = q.getCumulativeWeights();
        int pSamplesArrLen = pSamplesArr.length;
        int qSamplesArrLen = qSamplesArr.length;
        double n1 = sketch1.getN();
        double n2 = sketch2.getN();
        double deltaHeight = 0.0;
        int i = 0;
        int j = 0;
        while (i < pSamplesArrLen - 1 && j < qSamplesArrLen - 1) {
            deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
            if (pSamplesArr[i] < qSamplesArr[j]) {
                ++i;
                continue;
            }
            if (qSamplesArr[j] < pSamplesArr[i]) {
                ++j;
                continue;
            }
            ++i;
            ++j;
        }
        deltaHeight = Math.max(deltaHeight, Math.abs((double)pCumWtsArr[i] / n1 - (double)qCumWtsArr[j] / n2));
        return deltaHeight;
    }

    public static double computeKSThreshold(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double r1 = sketch1.getNumRetained();
        double r2 = sketch2.getNumRetained();
        double alpha = tgtPvalue;
        double alphaFactor = Math.sqrt(-0.5 * Math.log(0.5 * alpha));
        double deltaAreaThreshold = alphaFactor * Math.sqrt((r1 + r2) / (r1 * r2));
        double eps1 = sketch1.getNormalizedRankError(false);
        double eps2 = sketch2.getNormalizedRankError(false);
        return deltaAreaThreshold + eps1 + eps2;
    }

    public static boolean kolmogorovSmirnovTest(DoublesSketch sketch1, DoublesSketch sketch2, double tgtPvalue) {
        double thresh;
        double delta = KolmogorovSmirnov.computeKSDelta(sketch1, sketch2);
        return delta > (thresh = KolmogorovSmirnov.computeKSThreshold(sketch1, sketch2, tgtPvalue));
    }
}

