/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.queue;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.extender.internal.AbstractService;
import org.apache.felix.ipojo.extender.internal.queue.QueueNotifier;
import org.apache.felix.ipojo.extender.queue.JobInfo;
import org.apache.felix.ipojo.extender.queue.QueueListener;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQueueService
extends AbstractService
implements QueueService,
QueueNotifier {
    protected final List<QueueListener> m_listeners = new ArrayList<QueueListener>();

    protected AbstractQueueService(BundleContext bundleContext, Class<?> type) {
        super(bundleContext, type);
    }

    @Override
    public void addQueueListener(QueueListener listener) {
        this.m_listeners.add(listener);
    }

    @Override
    public void removeQueueListener(QueueListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public void fireEnlistedJobInfo(JobInfo info) {
        for (QueueListener listener : this.m_listeners) {
            listener.enlisted(info);
        }
    }

    @Override
    public void fireStartedJobInfo(JobInfo info) {
        for (QueueListener listener : this.m_listeners) {
            listener.started(info);
        }
    }

    @Override
    public void fireExecutedJobInfo(JobInfo info, Object result) {
        for (QueueListener listener : this.m_listeners) {
            listener.executed(info, result);
        }
    }

    @Override
    public void fireFailedJobInfo(JobInfo info, Throwable throwable) {
        for (QueueListener listener : this.m_listeners) {
            listener.failed(info, throwable);
        }
    }
}

