/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.parsing.as;

import java.util.ArrayList;
import org.apache.flex.compiler.internal.parsing.as.ASToken;
import org.apache.flex.compiler.internal.parsing.as.BaseRepairingTokenBuffer;
import org.apache.flex.compiler.internal.parsing.as.IRepairingTokenBuffer;
import org.apache.flex.compiler.internal.parsing.as.StreamingASTokenizer;
import org.apache.flex.compiler.parsing.IASToken;

public final class StreamingTokenBuffer
extends BaseRepairingTokenBuffer
implements IRepairingTokenBuffer {
    private static final int REWIND_BUFFER_SIZE = 10;
    private final StreamingASTokenizer tokenizer;
    private final ArrayList<ASToken> buffer;
    private int bufferSize;
    private ASToken previousToken;

    public StreamingTokenBuffer(StreamingASTokenizer tokens) {
        super(tokens.getSourcePath());
        this.tokenizer = tokens;
        this.buffer = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            this.buffer.add(this.eofToken);
        }
        this.bufferSize = 0;
        this.previousToken = this.eofToken;
    }

    public String getSourcePath() {
        return this.tokenizer.getSourcePath();
    }

    @Override
    public final boolean insertSemicolon(boolean isNextToken) {
        if (!this.insertSemis) {
            return false;
        }
        if (isNextToken) {
            this.onSemicolonInserted();
        }
        return true;
    }

    private final void fill(int distance) {
        for (int pos = 0; pos < distance; ++pos) {
            ASToken next = this.tokenizer.next();
            this.buffer.add(next);
            ++this.bufferSize;
        }
    }

    @Override
    public void rewind(int position) {
        int backSteps = this.position - position;
        if (backSteps > 10) {
            throw new IllegalStateException(String.format("Token buffer can't rewind that far. Max rewind is %d, but got %d.", 10, backSteps));
        }
        for (int i = 0; i < backSteps; ++i) {
            this.buffer.add(0, this.eofToken);
            ++this.bufferSize;
        }
        this.position = position;
    }

    @Override
    public final void consume() {
        if (this.nextIsSemicolon) {
            this.nextIsSemicolon = false;
            this.previousToken = SEMICOLON;
        } else {
            ++this.position;
            if (this.bufferSize > 0) {
                assert (this.previousToken != null);
                this.previousToken = this.buffer.get(10);
                this.buffer.remove(1);
                --this.bufferSize;
                assert (this.bufferSize >= 0) : "fBufferSize can not be negative";
            }
        }
    }

    @Override
    protected ASToken lookAheadSkipInsertedSemicolon(int i) {
        ASToken result;
        assert (this.bufferSize + 10 == this.buffer.size()) : "buffer size out-of-sync";
        if (this.bufferSize < i) {
            this.fill(i - this.bufferSize);
        }
        if ((result = this.buffer.get(9 + i)) != null) {
            result.lock();
        }
        return result != null ? result : this.eofToken;
    }

    public IASToken[] getTokens(boolean includeInserted) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASToken previous() {
        return this.previousToken != null ? this.previousToken : this.eofToken;
    }

    @Override
    public boolean matchOptionalSemicolon() {
        ASToken nextToken = this.LT(1);
        if (nextToken != null && nextToken.getType() != 1) {
            if (nextToken.getType() == 54) {
                this.consume();
            } else if (nextToken.getTokenKind() != IASToken.ASTokenKind.SCOPE_CLOSE && nextToken.getType() != 66) {
                if (nextToken.getLine() > this.previous().getLine()) {
                    this.insertSemicolon(false);
                } else if (!nextToken.getSourcePath().equals(this.previous().getSourcePath())) {
                    this.insertSemicolon(false);
                } else {
                    return false;
                }
            }
        }
        return true;
    }
}

