/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.SwfFormatException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public final class SwfDecoder
extends BufferedInputStream {
    private int offset;
    private int bitBuf;
    private int bitPos;
    int swfVersion;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream(256){

        @Override
        public byte[] toByteArray() {
            return this.buf;
        }
    };
    private int markOffset;

    public SwfDecoder(byte[] byArray, int n) {
        this((InputStream)null, n);
        this.buf = byArray;
        this.count = byArray.length;
        this.pos = 0;
    }

    public SwfDecoder(InputStream inputStream, int n) {
        super(inputStream);
        this.swfVersion = n;
    }

    public SwfDecoder(InputStream inputStream, int n, int n2) {
        this(inputStream, n);
        this.offset = n2;
    }

    public void readFully(byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        for (int i = byArray.length; i > 0; i -= n) {
            n = this.read(byArray, n2, i);
            if (n > 0) {
                n2 += n;
                continue;
            }
            throw new SwfFormatException("couldn't read " + i);
        }
    }

    @Override
    public int read() throws IOException {
        ++this.offset;
        return super.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        this.offset += n3;
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        long l2 = super.skip(l);
        this.offset = (int)((long)this.offset + l2);
        return l2;
    }

    public float readFixed8() throws IOException {
        int n = this.readUI16();
        return (float)((double)n / 256.0);
    }

    public int readUI8() throws IOException {
        if (this.pos < this.count) {
            ++this.offset;
            return this.buf[this.pos++] & 0xFF;
        }
        if (this.in != null) {
            ++this.offset;
            return super.read();
        }
        return -1;
    }

    public int readUI16() throws IOException {
        int n;
        this.syncBits();
        if (this.count - this.pos >= 2) {
            n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
            this.pos += 2;
            this.offset += 2;
        } else if (this.in != null) {
            n = super.read() | super.read() << 8;
            this.offset += 2;
        } else {
            return -1;
        }
        return n;
    }

    public long readUI32() throws IOException {
        long l = (long)this.readSI32() & 0xFFFFFFFFL;
        return l;
    }

    public int readSI32() throws IOException {
        int n;
        this.syncBits();
        if (this.count - this.pos >= 4) {
            n = this.buf[this.pos] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8 | (this.buf[this.pos + 2] & 0xFF) << 16 | this.buf[this.pos + 3] << 24;
            this.offset += 4;
            this.pos += 4;
        } else if (this.in != null) {
            n = super.read() | super.read() << 8 | super.read() << 16 | super.read() << 24;
            this.offset += 4;
        } else {
            n = -1;
        }
        return n;
    }

    public long read64() throws IOException {
        return this.readUI32() & 0xFFFFFFFFL | this.readUI32() << 32;
    }

    public boolean readBit() throws IOException {
        return this.readUBits(1) != 0;
    }

    public int readUBits(int n) throws IOException {
        int n2;
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        if (this.bitPos == 0) {
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        while ((n2 = n3 - this.bitPos) > 0) {
            n4 |= this.bitBuf << n2;
            n3 -= this.bitPos;
            this.bitBuf = this.readUI8();
            this.bitPos = 8;
        }
        this.bitPos -= n3;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return n4 |= this.bitBuf >> -n2;
    }

    public int readSBits(int n) throws IOException {
        if (n > 32) {
            throw new SwfFormatException("Number of bits > 32");
        }
        int n2 = this.readUBits(n);
        int n3 = 32 - n;
        n2 = n2 << n3 >> n3;
        return n2;
    }

    public int readSI16() throws IOException {
        return (short)this.readUI16();
    }

    public float readFloat() throws IOException {
        int n = this.readSI32();
        return Float.intBitsToFloat(n);
    }

    public String readLengthString() throws IOException {
        int n = this.readUI8();
        byte[] byArray = new byte[n];
        this.readFully(byArray);
        if (this.swfVersion >= 6) {
            return new String(byArray, 0, n - 1, "UTF8").intern();
        }
        return new String(byArray, 0, n - 1).intern();
    }

    public String readString() throws IOException {
        int n;
        if (this.swfVersion >= 6) {
            return this.readUTF().intern();
        }
        while ((n = this.readUI8()) > 0) {
            this.out.write(n);
        }
        String string = new String(this.out.toByteArray(), 0, this.out.size());
        this.out.reset();
        return string.intern();
    }

    private String readUTF() throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        block5: while ((n = this.readUI8()) > 0) {
            switch (n >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    stringBuilder.append((char)n);
                    continue block5;
                }
                case 12: 
                case 13: {
                    int n2 = this.readUI8();
                    if (n2 <= 0 || (n2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuilder.append((char)((n & 0x1F) << 6 | n2 & 0x3F));
                    continue block5;
                }
                case 14: {
                    int n2 = this.readUI8();
                    int n3 = this.readUI8();
                    if (n2 <= 0 || n3 <= 0 || (n2 & 0xC0) != 128 || (n3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    stringBuilder.append((char)((n & 0xF) << 12 | (n2 & 0x3F) << 6 | n3 & 0x3F));
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        return stringBuilder.toString();
    }

    public void syncBits() {
        this.bitPos = 0;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public void mark(int n) {
        this.markOffset = this.offset;
        super.mark(n);
    }

    @Override
    public void reset() throws IOException {
        this.offset = this.markOffset;
        super.reset();
    }
}

