/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.chat;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.ollama4j.models.chat.OllamaChatMessage;
import io.github.ollama4j.models.chat.OllamaChatResponseModel;
import io.github.ollama4j.utils.Utils;
import java.util.List;
import lombok.Generated;

public class OllamaChatResult {
    private final List<OllamaChatMessage> chatHistory;
    private final OllamaChatResponseModel responseModel;

    public OllamaChatResult(OllamaChatResponseModel responseModel, List<OllamaChatMessage> chatHistory) {
        this.chatHistory = chatHistory;
        this.responseModel = responseModel;
        this.appendAnswerToChatHistory(responseModel);
    }

    private void appendAnswerToChatHistory(OllamaChatResponseModel response) {
        this.chatHistory.add(response.getMessage());
    }

    public String toString() {
        try {
            return Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public String getResponse() {
        return this.responseModel != null ? this.responseModel.getMessage().getContent() : "";
    }

    @Deprecated
    public int getHttpStatusCode() {
        return 200;
    }

    @Deprecated
    public long getResponseTime() {
        return this.responseModel != null ? this.responseModel.getTotalDuration() : 0L;
    }

    @Generated
    public List<OllamaChatMessage> getChatHistory() {
        return this.chatHistory;
    }

    @Generated
    public OllamaChatResponseModel getResponseModel() {
        return this.responseModel;
    }
}

