/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.ml.feature.dct.DCT;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class DCTExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        List<Vector> inputData = Arrays.asList(Vectors.dense((double[])new double[]{1.0, 1.0, 1.0, 1.0}), Vectors.dense((double[])new double[]{1.0, 0.0, -1.0, 0.0}));
        Table inputTable = tEnv.fromDataStream((DataStream)env.fromCollection(inputData)).as("input", new String[0]);
        DCT dct = new DCT();
        Table outputTable = dct.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Vector inputValue = (Vector)row.getFieldAs(dct.getInputCol());
            Vector outputValue = (Vector)row.getFieldAs(dct.getOutputCol());
            System.out.printf("Input Value: %s\tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

