/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.ml.feature.hashingtf.HashingTF;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class HashingTFExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource inputStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{Arrays.asList("HashingTFTest", "Hashing", "Term", "Frequency", "Test")}), Row.of((Object[])new Object[]{Arrays.asList("HashingTFTest", "Hashing", "Hashing", "Test", "Test")})});
        Table inputTable = tEnv.fromDataStream((DataStream)inputStream).as("input", new String[0]);
        HashingTF hashingTF = (HashingTF)((HashingTF)((HashingTF)new HashingTF().setInputCol("input")).setOutputCol("output")).setNumFeatures(128);
        Table outputTable = hashingTF.transform(new Table[]{inputTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            List inputValue = (List)row.getField(hashingTF.getInputCol());
            SparseVector outputValue = (SparseVector)row.getField(hashingTF.getOutputCol());
            System.out.printf("Input Value: %s \tOutput Value: %s\n", Arrays.toString(inputValue.stream().toArray()), outputValue);
        }
    }
}

