/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import org.apache.flink.ml.feature.onehotencoder.OneHotEncoder;
import org.apache.flink.ml.feature.onehotencoder.OneHotEncoderModel;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class OneHotEncoderExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource trainStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{0.0}), Row.of((Object[])new Object[]{1.0}), Row.of((Object[])new Object[]{2.0}), Row.of((Object[])new Object[]{0.0})});
        Table trainTable = tEnv.fromDataStream((DataStream)trainStream).as("input", new String[0]);
        DataStreamSource predictStream = env.fromElements((Object[])new Row[]{Row.of((Object[])new Object[]{0.0}), Row.of((Object[])new Object[]{1.0}), Row.of((Object[])new Object[]{2.0})});
        Table predictTable = tEnv.fromDataStream((DataStream)predictStream).as("input", new String[0]);
        OneHotEncoder oneHotEncoder = (OneHotEncoder)((OneHotEncoder)new OneHotEncoder().setInputCols(new String[]{"input"})).setOutputCols(new String[]{"output"});
        OneHotEncoderModel model = oneHotEncoder.fit(new Table[]{trainTable});
        Table outputTable = model.transform(new Table[]{predictTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Double inputValue = (Double)row.getField(oneHotEncoder.getInputCols()[0]);
            SparseVector outputValue = (SparseVector)row.getField(oneHotEncoder.getOutputCols()[0]);
            System.out.printf("Input Value: %s\tOutput Value: %s\n", inputValue, outputValue);
        }
    }
}

