/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.common.broadcast.typeinfo;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.common.broadcast.typeinfo.CacheElement;

public class CacheElementSerializer<T>
extends TypeSerializer<CacheElement<T>> {
    private final TypeSerializer<T> recordSerializer;

    public CacheElementSerializer(TypeSerializer<T> recordSerializer) {
        this.recordSerializer = recordSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<CacheElement<T>> duplicate() {
        return new CacheElementSerializer<T>(this.recordSerializer.duplicate());
    }

    public CacheElement<T> createInstance() {
        return null;
    }

    public CacheElement<T> copy(CacheElement<T> from) {
        switch (from.getType()) {
            case RECORD: {
                return CacheElement.newRecord(this.recordSerializer.copy(from.getRecord()));
            }
            case WATERMARK: {
                return CacheElement.newWatermark(from.getWatermark());
            }
        }
        throw new RuntimeException("Unsupported Record or Watermark type " + (Object)((Object)from.getType()));
    }

    public CacheElement<T> copy(CacheElement<T> from, CacheElement<T> reuse) {
        switch (from.getType()) {
            case RECORD: {
                if (reuse.getRecord() != null) {
                    this.recordSerializer.copy(from.getRecord(), reuse.getRecord());
                    break;
                }
                reuse.setRecord(this.recordSerializer.copy(from.getRecord()));
                break;
            }
            case WATERMARK: {
                reuse.setWatermark(from.getWatermark());
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Record or Watermark type " + (Object)((Object)from.getType()));
            }
        }
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public void serialize(CacheElement<T> record, DataOutputView target) throws IOException {
        target.writeByte((int)((byte)record.getType().ordinal()));
        switch (record.getType()) {
            case RECORD: {
                this.recordSerializer.serialize(record.getRecord(), target);
                break;
            }
            case WATERMARK: {
                LongSerializer.INSTANCE.serialize(Long.valueOf(record.getWatermark()), target);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Record or Watermark type " + (Object)((Object)record.getType()));
            }
        }
    }

    public CacheElement<T> deserialize(DataInputView source) throws IOException {
        byte type = source.readByte();
        switch (CacheElement.Type.values()[type]) {
            case RECORD: {
                Object value = this.recordSerializer.deserialize(source);
                return CacheElement.newRecord(value);
            }
            case WATERMARK: {
                long watermark = LongSerializer.INSTANCE.deserialize(source);
                return CacheElement.newWatermark(watermark);
            }
        }
        throw new RuntimeException("Unsupported Record or Watermark type " + type);
    }

    public CacheElement<T> deserialize(CacheElement<T> reuse, DataInputView source) throws IOException {
        byte type = source.readByte();
        switch (CacheElement.Type.values()[type]) {
            case RECORD: {
                reuse.setType(CacheElement.Type.RECORD);
                reuse.setRecord(this.recordSerializer.deserialize(source));
                break;
            }
            case WATERMARK: {
                reuse.setType(CacheElement.Type.WATERMARK);
                reuse.setWatermark(LongSerializer.INSTANCE.deserialize(source));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported Record or Watermark type " + type);
            }
        }
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        Object cacheElement = this.deserialize(source);
        this.serialize((CacheElement<T>)cacheElement, target);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CacheElementSerializer that = (CacheElementSerializer)((Object)obj);
        return Objects.equals(this.recordSerializer, that.recordSerializer);
    }

    public int hashCode() {
        return this.recordSerializer != null ? this.recordSerializer.hashCode() : 0;
    }

    public TypeSerializerSnapshot<CacheElement<T>> snapshotConfiguration() {
        return new CacheElementSerializerSnapshot();
    }

    private static final class CacheElementSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<CacheElement<T>, CacheElementSerializer<T>> {
        private static final int CURRENT_VERSION = 1;

        public CacheElementSerializerSnapshot() {
            super(CacheElementSerializer.class);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 1;
        }

        protected TypeSerializer<?>[] getNestedSerializers(CacheElementSerializer<T> tIterationRecordSerializer) {
            return new TypeSerializer[]{((CacheElementSerializer)tIterationRecordSerializer).recordSerializer};
        }

        protected CacheElementSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] typeSerializers) {
            TypeSerializer<?> elementSerializer = typeSerializers[0];
            return new CacheElementSerializer(elementSerializer);
        }
    }
}

