/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.idf;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.array.LongPrimitiveArraySerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.file.src.reader.SimpleStreamFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.typeinfo.DenseVectorSerializer;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;

public class IDFModelData {
    public DenseVector idf;
    public long[] docFreq;
    public long numDocs;

    public IDFModelData() {
    }

    public IDFModelData(DenseVector idf, long[] docFreq, long numDocs) {
        this.idf = idf;
        this.docFreq = docFreq;
        this.numDocs = numDocs;
    }

    public static DataStream<IDFModelData> getModelDataStream(Table modelDataTable) {
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)modelDataTable).getTableEnvironment();
        return tEnv.toDataStream(modelDataTable).map((MapFunction & Serializable)x -> new IDFModelData((DenseVector)x.getFieldAs(0), (long[])x.getFieldAs(1), (Long)x.getFieldAs(2)));
    }

    public static class ModelDataDecoder
    extends SimpleStreamFormat<IDFModelData> {
        public StreamFormat.Reader<IDFModelData> createReader(Configuration config, final FSDataInputStream stream) {
            return new StreamFormat.Reader<IDFModelData>(){
                private final DenseVectorSerializer denseVectorSerializer = new DenseVectorSerializer();

                public IDFModelData read() throws IOException {
                    DataInputViewStreamWrapper source = new DataInputViewStreamWrapper((InputStream)stream);
                    try {
                        DenseVector idf = this.denseVectorSerializer.deserialize((DataInputView)source);
                        long[] docFreq = LongPrimitiveArraySerializer.INSTANCE.deserialize((DataInputView)source);
                        long numDocs = LongSerializer.INSTANCE.deserialize((DataInputView)source);
                        return new IDFModelData(idf, docFreq, numDocs);
                    }
                    catch (EOFException e) {
                        return null;
                    }
                }

                public void close() throws IOException {
                    stream.close();
                }
            };
        }

        public TypeInformation<IDFModelData> getProducedType() {
            return TypeInformation.of(IDFModelData.class);
        }
    }

    public static class ModelDataEncoder
    implements Encoder<IDFModelData> {
        private final DenseVectorSerializer denseVectorSerializer = new DenseVectorSerializer();

        public void encode(IDFModelData modelData, OutputStream outputStream) throws IOException {
            DataOutputViewStreamWrapper dataOutputView = new DataOutputViewStreamWrapper(outputStream);
            this.denseVectorSerializer.serialize(modelData.idf, (DataOutputView)dataOutputView);
            LongPrimitiveArraySerializer.INSTANCE.serialize(modelData.docFreq, (DataOutputView)dataOutputView);
            LongSerializer.INSTANCE.serialize(Long.valueOf(modelData.numDocs), (DataOutputView)dataOutputView);
        }
    }
}

