/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.imputer;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.imputer.ImputerModelData;
import org.apache.flink.ml.feature.imputer.ImputerModelParams;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class ImputerModel
implements Model<ImputerModel>,
ImputerModelParams<ImputerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public ImputerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public ImputerModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(ImputerModelData.getModelDataStream(this.modelDataTable), path, new ImputerModelData.ModelDataEncoder());
    }

    public static ImputerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        ImputerModel model = (ImputerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new ImputerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String[] inputCols = this.getInputCols();
        Object[] outputCols = this.getOutputCols();
        Preconditions.checkArgument((inputCols.length == outputCols.length ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream dataStream = tEnv.toDataStream(inputs[0]);
        DataStream<ImputerModelData> imputerModel = ImputerModelData.getModelDataStream(this.modelDataTable);
        String broadcastModelKey = "broadcastModelKey";
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        Object[] outputTypes = new TypeInformation[outputCols.length];
        Arrays.fill(outputTypes, BasicTypeInfo.DOUBLE_TYPE_INFO);
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])outputTypes), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])outputCols));
        DataStream output = BroadcastUtils.withBroadcastStream(Collections.singletonList(dataStream), Collections.singletonMap("broadcastModelKey", imputerModel), inputList -> {
            DataStream input = (DataStream)inputList.get(0);
            return input.map((MapFunction)new PredictOutputFunction(this.getMissingValue(), inputCols, "broadcastModelKey"), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(output)};
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String[] inputCols;
        private final String broadcastKey;
        private final double missingValue;
        private Map<String, Double> surrogates;

        public PredictOutputFunction(double missingValue, String[] inputCols, String broadcastKey) {
            this.missingValue = missingValue;
            this.inputCols = inputCols;
            this.broadcastKey = broadcastKey;
        }

        public Row map(Row row) throws Exception {
            if (this.surrogates == null) {
                ImputerModelData imputerModelData = (ImputerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastKey).get(0);
                this.surrogates = imputerModelData.surrogates;
                Arrays.stream(this.inputCols).forEach(col -> Preconditions.checkArgument((boolean)this.surrogates.containsKey(col), (String)"Column %s is unacceptable for the Imputer model.", (Object[])new Object[]{col}));
            }
            Row outputRow = new Row(this.inputCols.length);
            for (int i = 0; i < this.inputCols.length; ++i) {
                Object value = row.getField(i);
                if (value == null || Double.valueOf(value.toString()).equals(this.missingValue)) {
                    double surrogate = this.surrogates.get(this.inputCols[i]);
                    outputRow.setField(i, (Object)surrogate);
                    continue;
                }
                outputRow.setField(i, (Object)Double.valueOf(value.toString()));
            }
            return Row.join((Row)row, (Row[])new Row[]{outputRow});
        }
    }
}

