/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.interaction;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Transformer;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.interaction.InteractionParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.Vectors;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class Interaction
implements Transformer<Interaction>,
InteractionParams<Interaction> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public Interaction() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        SingleOutputStreamOperator output = tEnv.toDataStream(inputs[0]).map((MapFunction)new InteractionFunction(this.getInputCols()), (TypeInformation)outputTypeInfo);
        Table outputTable = tEnv.fromDataStream((DataStream)output);
        return new Table[]{outputTable};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static Interaction load(StreamTableEnvironment env, String path) throws IOException {
        return (Interaction)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class InteractionFunction
    implements MapFunction<Row, Row> {
        private final String[] inputCols;
        private final int[] featureSize;
        private final int[][] featureIndices;
        private final double[][] featureValues;

        public InteractionFunction(String[] inputCols) {
            this.inputCols = inputCols;
            this.featureSize = new int[inputCols.length];
            this.featureIndices = new int[inputCols.length][];
            this.featureValues = new double[inputCols.length][];
        }

        public Row map(Row value) {
            Vector ret;
            int nnz = 1;
            boolean hasSparse = false;
            for (int i = 0; i < this.inputCols.length; ++i) {
                Object obj = value.getField(this.inputCols[i]);
                if (obj == null) {
                    return Row.join((Row)value, (Row[])new Row[]{Row.of((Object[])new Object[]{null})});
                }
                if (obj instanceof DenseVector) {
                    this.featureSize[i] = ((Vector)obj).size();
                    if (this.featureIndices[i] == null || this.featureIndices[i].length != this.featureSize[i]) {
                        this.featureIndices[i] = new int[this.featureSize[i]];
                        for (int j = 0; j < this.featureSize[i]; ++j) {
                            this.featureIndices[i][j] = j;
                        }
                    }
                    this.featureValues[i] = ((DenseVector)obj).values;
                    nnz *= this.featureSize[i];
                    continue;
                }
                if (obj instanceof SparseVector) {
                    this.featureSize[i] = ((Vector)obj).size();
                    this.featureIndices[i] = ((SparseVector)obj).indices;
                    this.featureValues[i] = ((SparseVector)obj).values;
                    nnz *= ((SparseVector)obj).values.length;
                    hasSparse = true;
                    continue;
                }
                this.featureSize[i] = 1;
                this.featureIndices[i] = new int[]{0};
                this.featureValues[i] = new double[]{Double.parseDouble(obj.toString())};
            }
            int featureIter = this.inputCols.length - 1;
            if (hasSparse) {
                int[] indices = new int[nnz];
                double[] values = new double[nnz];
                Arrays.fill(values, 1.0);
                int offset = 1;
                int size = 1;
                while (featureIter >= 0) {
                    int[] prevIndices = this.featureIndices[featureIter];
                    double[] prevValues = this.featureValues[featureIter];
                    for (int i = 0; i < nnz / offset; ++i) {
                        int idxOffset = i * offset;
                        int idx = i % prevValues.length;
                        for (int j = 0; j < offset; ++j) {
                            int n = idxOffset + j;
                            values[n] = values[n] * prevValues[idx];
                            int n2 = idxOffset + j;
                            indices[n2] = indices[n2] + prevIndices[idx] * size;
                        }
                    }
                    offset *= prevValues.length;
                    size *= this.featureSize[featureIter--];
                }
                ret = Vectors.sparse(size, indices, values);
            } else {
                double[] values = new double[nnz];
                Arrays.fill(values, 1.0);
                int idxOffset = 1;
                while (featureIter >= 0) {
                    double[] prevValues = this.featureValues[featureIter--];
                    for (int i = 0; i < nnz / idxOffset; ++i) {
                        int innerOffset = i * idxOffset;
                        int idx = i % prevValues.length;
                        for (int j = 0; j < idxOffset; ++j) {
                            int n = innerOffset + j;
                            values[n] = values[n] * prevValues[idx];
                        }
                    }
                    idxOffset *= prevValues.length;
                }
                ret = new DenseVector(values);
            }
            return Row.join((Row)value, (Row[])new Row[]{Row.of((Object[])new Object[]{ret})});
        }
    }
}

