/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.robustscaler;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.ml.api.Estimator;
import org.apache.flink.ml.common.datastream.DataStreamUtils;
import org.apache.flink.ml.common.util.QuantileSummary;
import org.apache.flink.ml.feature.robustscaler.RobustScalerModel;
import org.apache.flink.ml.feature.robustscaler.RobustScalerModelData;
import org.apache.flink.ml.feature.robustscaler.RobustScalerParams;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.util.Preconditions;

public class RobustScaler
implements Estimator<RobustScaler, RobustScalerModel>,
RobustScalerParams<RobustScaler> {
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public RobustScaler() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public RobustScalerModel fit(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        String inputCol = this.getInputCol();
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        SingleOutputStreamOperator inputData = tEnv.toDataStream(inputs[0]).map((MapFunction & Serializable)value -> ((Vector)value.getField(inputCol)).toDense());
        DataStream<RobustScalerModelData> modelData = DataStreamUtils.aggregate(inputData, new QuantileAggregator(this.getRelativeError(), this.getLower(), this.getUpper()));
        RobustScalerModel model = new RobustScalerModel().setModelData(tEnv.fromDataStream(modelData));
        ParamUtils.updateExistingParams(model, this.getParamMap());
        return model;
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
    }

    public static RobustScaler load(StreamTableEnvironment tEnv, String path) throws IOException {
        return (RobustScaler)ReadWriteUtils.loadStageParam(path);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    private static class QuantileAggregator
    implements AggregateFunction<DenseVector, QuantileSummary[], RobustScalerModelData> {
        private final double relativeError;
        private final double lower;
        private final double upper;

        public QuantileAggregator(double relativeError, double lower, double upper) {
            this.relativeError = relativeError;
            this.lower = lower;
            this.upper = upper;
        }

        public QuantileSummary[] createAccumulator() {
            return new QuantileSummary[0];
        }

        public QuantileSummary[] add(DenseVector denseVector, QuantileSummary[] quantileSummaries) {
            int i;
            if (quantileSummaries.length == 0) {
                quantileSummaries = new QuantileSummary[denseVector.size()];
                for (i = 0; i < denseVector.size(); ++i) {
                    quantileSummaries[i] = new QuantileSummary(this.relativeError);
                }
            }
            Preconditions.checkState((denseVector.size() == quantileSummaries.length ? 1 : 0) != 0, (String)"Number of features must be %s but got %s.", (Object[])new Object[]{quantileSummaries.length, denseVector.size()});
            for (i = 0; i < quantileSummaries.length; ++i) {
                double value = denseVector.get(i);
                if (Double.isNaN(value)) continue;
                quantileSummaries[i] = quantileSummaries[i].insert(value);
            }
            return quantileSummaries;
        }

        public RobustScalerModelData getResult(QuantileSummary[] quantileSummaries) {
            Preconditions.checkState((quantileSummaries.length != 0 ? 1 : 0) != 0, (Object)"The training set is empty.");
            DenseVector medianVector = new DenseVector(quantileSummaries.length);
            DenseVector rangeVector = new DenseVector(quantileSummaries.length);
            for (int i = 0; i < quantileSummaries.length; ++i) {
                QuantileSummary compressed = quantileSummaries[i].compress();
                double[] quantiles = compressed.query(new double[]{0.5, this.lower, this.upper});
                medianVector.values[i] = quantiles[0];
                rangeVector.values[i] = quantiles[2] - quantiles[1];
            }
            return new RobustScalerModelData(medianVector, rangeVector);
        }

        public QuantileSummary[] merge(QuantileSummary[] summaries, QuantileSummary[] acc) {
            if (summaries.length == 0) {
                return Arrays.stream(acc).map(QuantileSummary::compress).collect(Collectors.toList()).toArray(acc);
            }
            if (acc.length == 0) {
                return Arrays.stream(summaries).map(QuantileSummary::compress).collect(Collectors.toList()).toArray(summaries);
            }
            Preconditions.checkState((summaries.length == acc.length ? 1 : 0) != 0);
            for (int i = 0; i < summaries.length; ++i) {
                acc[i] = acc[i].compress().merge(summaries[i].compress());
            }
            return acc;
        }
    }
}

