/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.util.Map;
import java.util.Objects;
import org.apache.flink.statefun.flink.common.SetContextClassLoader;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.FunctionLoader;
import org.apache.flink.statefun.sdk.FunctionType;
import org.apache.flink.statefun.sdk.StatefulFunction;
import org.apache.flink.statefun.sdk.StatefulFunctionProvider;

final class PredefinedFunctionLoader
implements FunctionLoader {
    private final Map<FunctionType, StatefulFunctionProvider> functionProviders;
    private final Map<String, StatefulFunctionProvider> namespaceFunctionProviders;

    @Inject
    PredefinedFunctionLoader(@Label(value="function-providers") Map<FunctionType, StatefulFunctionProvider> functionProviders, @Label(value="namespace-function-providers") Map<String, StatefulFunctionProvider> namespaceFunctionProviders) {
        this.functionProviders = Objects.requireNonNull(functionProviders);
        this.namespaceFunctionProviders = Objects.requireNonNull(namespaceFunctionProviders);
    }

    @Override
    public StatefulFunction load(FunctionType functionType) {
        Objects.requireNonNull(functionType);
        StatefulFunctionProvider provider = this.getFunctionProviderOrThrow(functionType);
        StatefulFunction statefulFunction = PredefinedFunctionLoader.load(provider, functionType);
        if (statefulFunction == null) {
            throw new IllegalStateException("A provider for a type " + functionType + " has produced a NULL function");
        }
        return statefulFunction;
    }

    private StatefulFunctionProvider getFunctionProviderOrThrow(FunctionType functionType) {
        StatefulFunctionProvider provider = this.functionProviders.get(functionType);
        if (provider != null) {
            return provider;
        }
        provider = this.namespaceFunctionProviders.get(functionType.namespace());
        if (provider != null) {
            return provider;
        }
        throw new IllegalArgumentException("Cannot find a provider for type " + functionType);
    }

    private static StatefulFunction load(StatefulFunctionProvider provider, FunctionType functionType) {
        try (SetContextClassLoader ignored = new SetContextClassLoader((Object)provider);){
            StatefulFunction statefulFunction = provider.functionOfType(functionType);
            return statefulFunction;
        }
    }
}

