/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.jsonmodule;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import org.apache.flink.statefun.flink.common.ResourceLocator;
import org.apache.flink.statefun.flink.common.json.Selectors;
import org.apache.flink.statefun.flink.core.jsonmodule.FormatVersion;
import org.apache.flink.statefun.flink.core.jsonmodule.LegacyRemoteModuleV30;
import org.apache.flink.statefun.flink.core.jsonmodule.ModuleType;
import org.apache.flink.statefun.flink.core.jsonmodule.RemoteModule;
import org.apache.flink.statefun.sdk.spi.StatefulFunctionModule;

public final class JsonServiceLoader {
    private static final JsonPointer FORMAT_VERSION = JsonPointer.compile((String)"/version");
    private static final JsonPointer MODULE_SPEC = JsonPointer.compile((String)"/module/spec");
    private static final JsonPointer MODULE_META_TYPE = JsonPointer.compile((String)"/module/meta/type");

    public static Iterable<StatefulFunctionModule> load(String moduleName) {
        ObjectMapper mapper = JsonServiceLoader.mapper();
        Iterable namedResources = ResourceLocator.findResources((String)moduleName);
        return StreamSupport.stream(namedResources.spliterator(), false).map(moduleUrl -> JsonServiceLoader.fromUrl(mapper, moduleUrl)).collect(Collectors.toList());
    }

    @VisibleForTesting
    static StatefulFunctionModule fromUrl(ObjectMapper mapper, URL moduleUrl) {
        try {
            List<JsonNode> allComponentNodes = JsonServiceLoader.readAllComponentNodes(mapper, moduleUrl);
            if (JsonServiceLoader.isLegacySingleRootFormat(allComponentNodes)) {
                return JsonServiceLoader.createLegacyRemoteModule(allComponentNodes.get(0), moduleUrl);
            }
            return new RemoteModule(allComponentNodes);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed loading a module at " + moduleUrl, t);
        }
    }

    private static List<JsonNode> readAllComponentNodes(ObjectMapper mapper, URL moduleYamlFile) throws IOException {
        YAMLFactory yaml = new YAMLFactory();
        YAMLParser yamlParser = yaml.createParser(moduleYamlFile);
        return mapper.readValues((JsonParser)yamlParser, JsonNode.class).readAll();
    }

    private static void validateMeta(URL moduleYamlFile, JsonNode root) {
        JsonNode typeNode = root.at(MODULE_META_TYPE);
        if (typeNode.isMissingNode()) {
            throw new IllegalStateException("Unable to find a module type in " + moduleYamlFile);
        }
        if (!typeNode.asText().equalsIgnoreCase(ModuleType.REMOTE.name())) {
            throw new IllegalStateException("Unknown module type " + typeNode.asText() + ", currently supported: " + (Object)((Object)ModuleType.REMOTE));
        }
    }

    private static JsonNode requireValidModuleSpecNode(URL moduleYamlFile, JsonNode root) {
        JsonNode moduleSpecNode = root.at(MODULE_SPEC);
        if (moduleSpecNode.isMissingNode()) {
            throw new IllegalStateException("A module without a spec at " + moduleYamlFile);
        }
        return moduleSpecNode;
    }

    private static boolean isLegacySingleRootFormat(List<JsonNode> allComponentNodes) {
        if (allComponentNodes.size() == 1) {
            JsonNode singleRootNode = allComponentNodes.get(0);
            return JsonServiceLoader.hasLegacyFormatVersionField(singleRootNode);
        }
        return false;
    }

    private static boolean hasLegacyFormatVersionField(JsonNode singleRootNode) {
        return Selectors.optionalTextAt((JsonNode)singleRootNode, (JsonPointer)FORMAT_VERSION).isPresent();
    }

    private static StatefulFunctionModule createLegacyRemoteModule(JsonNode singleRootNode, URL moduleUrl) {
        JsonServiceLoader.validateMeta(moduleUrl, singleRootNode);
        FormatVersion version = JsonServiceLoader.requireValidFormatVersion(singleRootNode);
        switch (version) {
            case v3_0: {
                return new LegacyRemoteModuleV30(JsonServiceLoader.requireValidModuleSpecNode(moduleUrl, singleRootNode));
            }
        }
        throw new IllegalStateException("Unrecognized format version: " + (Object)((Object)version));
    }

    private static FormatVersion requireValidFormatVersion(JsonNode root) {
        String formatVersionStr = Selectors.textAt((JsonNode)root, (JsonPointer)FORMAT_VERSION);
        FormatVersion formatVersion = FormatVersion.fromString(formatVersionStr);
        if (formatVersion.compareTo(FormatVersion.v3_0) < 0) {
            throw new IllegalArgumentException("Only format versions higher than or equal to 3.0 is supported. Was version " + (Object)((Object)formatVersion) + ".");
        }
        return formatVersion;
    }

    @VisibleForTesting
    static ObjectMapper mapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory());
    }
}

