/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.translation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverse;
import org.apache.flink.statefun.flink.core.StatefulFunctionsUniverses;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.flink.core.message.MessageFactoryKey;
import org.apache.flink.statefun.flink.core.metrics.FlinkUserMetrics;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.io.IngressIdentifier;
import org.apache.flink.statefun.sdk.io.Router;
import org.apache.flink.statefun.sdk.metrics.Metrics;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IngressRouterOperator<T>
extends AbstractStreamOperator<Message>
implements OneInputStreamOperator<T, Message> {
    private static final Logger LOG = LoggerFactory.getLogger(IngressRouterOperator.class);
    private static final long serialVersionUID = 1L;
    private final StatefulFunctionsConfig configuration;
    private final IngressIdentifier<T> id;
    private transient List<Router<T>> routers;
    private transient DownstreamCollector<T> downstream;

    IngressRouterOperator(StatefulFunctionsConfig configuration, IngressIdentifier<T> id) {
        this.configuration = configuration;
        this.id = Objects.requireNonNull(id);
        this.chainingStrategy = ChainingStrategy.ALWAYS;
    }

    public void open() throws Exception {
        super.open();
        StatefulFunctionsUniverse universe = StatefulFunctionsUniverses.get(Thread.currentThread().getContextClassLoader(), this.configuration);
        LOG.info("Using message factory key " + universe.messageFactoryKey());
        MetricGroup routersMetricGroup = this.getMetricGroup().addGroup("routers").addGroup(this.id.namespace()).addGroup(this.id.name());
        FlinkUserMetrics routersMetrics = new FlinkUserMetrics(routersMetricGroup);
        this.routers = IngressRouterOperator.loadRoutersAttachedToIngress(this.id, universe.routers());
        this.downstream = new DownstreamCollector(universe.messageFactoryKey(), (Output<StreamRecord<Message>>)this.output, routersMetrics);
    }

    public void processElement(StreamRecord<T> element) {
        Object value = element.getValue();
        for (Router<T> router : this.routers) {
            router.route(value, this.downstream);
        }
    }

    private static <T> List<Router<T>> loadRoutersAttachedToIngress(IngressIdentifier<T> id, Map<IngressIdentifier<?>, List<Router<?>>> definedRouters) {
        List<Router<T>> routerList = definedRouters.get(id);
        Preconditions.checkState((routerList != null ? 1 : 0) != 0, (Object)("unable to find a router for ingress " + id));
        return routerList;
    }

    @VisibleForTesting
    static final class DownstreamCollector<T>
    implements Router.Downstream<T> {
        private final MessageFactory factory;
        private final StreamRecord<Message> reuse = new StreamRecord(null);
        private final Output<StreamRecord<Message>> output;
        private final Metrics metrics;

        DownstreamCollector(MessageFactoryKey messageFactoryKey, Output<StreamRecord<Message>> output, Metrics metrics) {
            this.factory = MessageFactory.forKey(messageFactoryKey);
            this.output = Objects.requireNonNull(output);
            this.metrics = Objects.requireNonNull(metrics);
        }

        public void forward(Address to, Object message) {
            if (to == null) {
                throw new NullPointerException("Unable to send a message downstream without an address.");
            }
            if (message == null) {
                throw new NullPointerException("message is mandatory parameter and can not be NULL.");
            }
            Message envelope = this.factory.from(null, to, message);
            this.output.collect((Object)this.reuse.replace((Object)envelope));
        }

        public Metrics metrics() {
            return this.metrics;
        }
    }
}

