/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.feature.standardscaler;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RichMapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.ml.api.Model;
import org.apache.flink.ml.common.broadcast.BroadcastUtils;
import org.apache.flink.ml.common.datastream.TableUtils;
import org.apache.flink.ml.feature.standardscaler.StandardScalerModelData;
import org.apache.flink.ml.feature.standardscaler.StandardScalerParams;
import org.apache.flink.ml.linalg.BLAS;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.typeinfo.VectorTypeInfo;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ReadWriteUtils;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.table.api.internal.TableImpl;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class StandardScalerModel
implements Model<StandardScalerModel>,
StandardScalerParams<StandardScalerModel> {
    private final Map<Param<?>, Object> paramMap = new HashMap();
    private Table modelDataTable;

    public StandardScalerModel() {
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public Table[] transform(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        StreamTableEnvironment tEnv = (StreamTableEnvironment)((TableImpl)inputs[0]).getTableEnvironment();
        DataStream inputStream = tEnv.toDataStream(inputs[0]);
        RowTypeInfo inputTypeInfo = TableUtils.getRowTypeInfo(inputs[0].getResolvedSchema());
        RowTypeInfo outputTypeInfo = new RowTypeInfo((TypeInformation[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldTypes(), (Object[])new TypeInformation[]{VectorTypeInfo.INSTANCE}), (String[])ArrayUtils.addAll((Object[])inputTypeInfo.getFieldNames(), (Object[])new String[]{this.getOutputCol()}));
        String broadcastModelKey = "broadcastModelKey";
        DataStream<StandardScalerModelData> modelDataStream = StandardScalerModelData.getModelDataStream(this.modelDataTable);
        DataStream predictionResult = BroadcastUtils.withBroadcastStream(Collections.singletonList(inputStream), Collections.singletonMap("broadcastModelKey", modelDataStream), inputList -> {
            DataStream inputData = (DataStream)inputList.get(0);
            return inputData.map((MapFunction)new PredictOutputFunction("broadcastModelKey", this.getInputCol(), this.getWithMean(), this.getWithStd()), (TypeInformation)outputTypeInfo);
        });
        return new Table[]{tEnv.fromDataStream(predictionResult)};
    }

    @Override
    public void save(String path) throws IOException {
        ReadWriteUtils.saveMetadata(this, path);
        ReadWriteUtils.saveModelData(StandardScalerModelData.getModelDataStream(this.modelDataTable), path, new StandardScalerModelData.ModelDataEncoder());
    }

    public static StandardScalerModel load(StreamTableEnvironment tEnv, String path) throws IOException {
        StandardScalerModel model = (StandardScalerModel)ReadWriteUtils.loadStageParam(path);
        Table modelDataTable = ReadWriteUtils.loadModelData(tEnv, path, new StandardScalerModelData.ModelDataDecoder());
        return model.setModelData(modelDataTable);
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }

    @Override
    public StandardScalerModel setModelData(Table ... inputs) {
        Preconditions.checkArgument((inputs.length == 1 ? 1 : 0) != 0);
        this.modelDataTable = inputs[0];
        return this;
    }

    @Override
    public Table[] getModelData() {
        return new Table[]{this.modelDataTable};
    }

    private static class PredictOutputFunction
    extends RichMapFunction<Row, Row> {
        private final String broadcastModelKey;
        private final String inputCol;
        private final boolean withMean;
        private final boolean withStd;
        private DenseVector mean;
        private DenseVector scale;

        public PredictOutputFunction(String broadcastModelKey, String inputCol, boolean withMean, boolean withStd) {
            this.broadcastModelKey = broadcastModelKey;
            this.inputCol = inputCol;
            this.withMean = withMean;
            this.withStd = withStd;
        }

        public Row map(Row dataPoint) {
            if (this.mean == null) {
                StandardScalerModelData modelData = (StandardScalerModelData)this.getRuntimeContext().getBroadcastVariable(this.broadcastModelKey).get(0);
                this.mean = modelData.mean;
                DenseVector std = modelData.std;
                if (this.withStd) {
                    this.scale = std;
                    double[] scaleValues = this.scale.values;
                    for (int i = 0; i < scaleValues.length; ++i) {
                        scaleValues[i] = scaleValues[i] == 0.0 ? 0.0 : 1.0 / scaleValues[i];
                    }
                }
            }
            Vector outputVec = ((Vector)dataPoint.getField(this.inputCol)).clone();
            if (this.withMean) {
                outputVec = outputVec.toDense();
                BLAS.axpy(-1.0, this.mean, (DenseVector)outputVec);
            }
            if (this.withStd) {
                BLAS.hDot((Vector)this.scale, outputVec);
            }
            return Row.join((Row)dataPoint, (Row[])new Row[]{Row.of((Object[])new Object[]{outputVec})});
        }
    }
}

