/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.servable.builder;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.servable.api.DataFrame;
import org.apache.flink.ml.servable.api.ModelServable;
import org.apache.flink.ml.servable.api.TransformerServable;
import org.apache.flink.ml.util.ParamUtils;
import org.apache.flink.ml.util.ServableReadWriteUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class PipelineModelServable
implements ModelServable<PipelineModelServable> {
    private final List<TransformerServable<?>> servables;
    private final Map<Param<?>, Object> paramMap = new HashMap();

    public PipelineModelServable(List<TransformerServable<?>> servables) {
        this.servables = (List)Preconditions.checkNotNull(servables);
        ParamUtils.initializeMapWithDefaultValues(this.paramMap, this);
    }

    @Override
    public DataFrame transform(DataFrame input) {
        for (TransformerServable<?> servable : this.servables) {
            input = servable.transform(input);
        }
        return input;
    }

    public static PipelineModelServable load(String path) throws IOException {
        return new PipelineModelServable(ServableReadWriteUtils.loadPipeline(path));
    }

    @Override
    public Map<Param<?>, Object> getParamMap() {
        return this.paramMap;
    }
}

