/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.Preconditions;

@Internal
class LocalRecoverable
implements RecoverableWriter.CommitRecoverable,
RecoverableWriter.ResumeRecoverable {
    private final File targetFile;
    private final File tempFile;
    private final long offset;

    LocalRecoverable(File targetFile, File tempFile, long offset) {
        Preconditions.checkArgument(offset >= 0L, "offset must be >= 0");
        this.targetFile = Preconditions.checkNotNull(targetFile, "targetFile");
        this.tempFile = Preconditions.checkNotNull(tempFile, "tempFile");
        this.offset = offset;
    }

    public File targetFile() {
        return this.targetFile;
    }

    public File tempFile() {
        return this.tempFile;
    }

    public long offset() {
        return this.offset;
    }

    public String toString() {
        return "LocalRecoverable " + this.tempFile + " @ " + this.offset + " -> " + this.targetFile;
    }
}

