/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.util.Objects;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.util.config.memory.FlinkMemory;
import org.apache.flink.runtime.util.config.memory.JvmMetaspaceAndOverhead;
import org.apache.flink.runtime.util.config.memory.ProcessMemorySpec;

public class CommonProcessMemorySpec<FM extends FlinkMemory>
implements ProcessMemorySpec {
    private static final long serialVersionUID = 1L;
    private final FM flinkMemory;
    private final JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead;

    protected CommonProcessMemorySpec(FM flinkMemory, JvmMetaspaceAndOverhead jvmMetaspaceAndOverhead) {
        this.flinkMemory = flinkMemory;
        this.jvmMetaspaceAndOverhead = jvmMetaspaceAndOverhead;
    }

    public FM getFlinkMemory() {
        return this.flinkMemory;
    }

    public JvmMetaspaceAndOverhead getJvmMetaspaceAndOverhead() {
        return this.jvmMetaspaceAndOverhead;
    }

    @Override
    public MemorySize getJvmHeapMemorySize() {
        return this.flinkMemory.getJvmHeapMemorySize();
    }

    @Override
    public MemorySize getJvmDirectMemorySize() {
        return this.flinkMemory.getJvmDirectMemorySize();
    }

    @Override
    public MemorySize getJvmMetaspaceSize() {
        return this.getJvmMetaspaceAndOverhead().getMetaspace();
    }

    @Override
    public MemorySize getJvmOverheadSize() {
        return this.getJvmMetaspaceAndOverhead().getOverhead();
    }

    @Override
    public MemorySize getTotalFlinkMemorySize() {
        return this.flinkMemory.getTotalFlinkMemorySize();
    }

    @Override
    public MemorySize getTotalProcessMemorySize() {
        return this.flinkMemory.getTotalFlinkMemorySize().add(this.getJvmMetaspaceSize()).add(this.getJvmOverheadSize());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            CommonProcessMemorySpec that = (CommonProcessMemorySpec)obj;
            return Objects.equals(this.flinkMemory, that.flinkMemory) && Objects.equals(this.jvmMetaspaceAndOverhead, that.jvmMetaspaceAndOverhead);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.flinkMemory, this.jvmMetaspaceAndOverhead);
    }
}

