/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.scalar;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.functions.BuiltInFunctionDefinitions;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.runtime.functions.scalar.BuiltInScalarFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.logical.LogicalType;

@Internal
public class TypeOfFunction
extends BuiltInScalarFunction {
    private final String typeString;
    private transient StringData typeStringData;

    public TypeOfFunction(SpecializedFunction.SpecializedContext context) {
        super(BuiltInFunctionDefinitions.TYPE_OF, context);
        CallContext callContext = context.getCallContext();
        this.typeString = TypeOfFunction.createTypeString(callContext, TypeOfFunction.isForceSerializable(callContext));
    }

    private static boolean isForceSerializable(CallContext context) {
        List<DataType> argumentDataTypes = context.getArgumentDataTypes();
        if (argumentDataTypes.size() != 2) {
            return false;
        }
        return context.getArgumentValue(1, Boolean.class).orElse(false);
    }

    @Nullable
    private static String createTypeString(CallContext context, boolean forceSerializable) {
        LogicalType input = context.getArgumentDataTypes().get(0).getLogicalType();
        if (forceSerializable) {
            try {
                return input.asSerializableString();
            }
            catch (Exception t) {
                return null;
            }
        }
        return input.asSummaryString();
    }

    @Override
    public void open(FunctionContext context) throws Exception {
        this.typeStringData = StringData.fromString(this.typeString);
    }

    @Nullable
    public StringData eval(Object ... unused) {
        return this.typeStringData;
    }
}

