/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Objects;
import org.apache.flink.runtime.checkpoint.SnapshotType;

public final class CheckpointType
implements SnapshotType {
    public static final CheckpointType CHECKPOINT = new CheckpointType("Checkpoint", SnapshotType.SharingFilesStrategy.FORWARD_BACKWARD);
    public static final CheckpointType FULL_CHECKPOINT = new CheckpointType("Full Checkpoint", SnapshotType.SharingFilesStrategy.FORWARD);
    private final String name;
    private final SnapshotType.SharingFilesStrategy sharingFilesStrategy;

    private CheckpointType(String name, SnapshotType.SharingFilesStrategy sharingFilesStrategy) {
        this.name = name;
        this.sharingFilesStrategy = sharingFilesStrategy;
    }

    @Override
    public boolean isSavepoint() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SnapshotType.SharingFilesStrategy getSharingFilesStrategy() {
        return this.sharingFilesStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckpointType type = (CheckpointType)o;
        return this.name.equals(type.name) && this.sharingFilesStrategy == type.sharingFilesStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sharingFilesStrategy});
    }

    public String toString() {
        return "CheckpointType{name='" + this.name + '\'' + ", sharingFilesStrategy=" + (Object)((Object)this.sharingFilesStrategy) + '}';
    }
}

