/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.AbstractMetricGroup;

@Internal
public class GenericMetricGroup
extends AbstractMetricGroup<AbstractMetricGroup<?>> {
    private String name;

    public GenericMetricGroup(MetricRegistry registry, AbstractMetricGroup parent, String name) {
        super(registry, GenericMetricGroup.makeScopeComponents(parent, name), parent);
        this.name = name;
    }

    @Override
    protected QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return this.parent.getQueryServiceMetricInfo(filter).copy(filter.filterCharacters(this.name));
    }

    private static String[] makeScopeComponents(AbstractMetricGroup parent, String name) {
        String[] parentComponents;
        if (parent != null && (parentComponents = parent.getScopeComponents()) != null && parentComponents.length > 0) {
            String[] parts = new String[parentComponents.length + 1];
            System.arraycopy(parentComponents, 0, parts, 0, parentComponents.length);
            parts[parts.length - 1] = name;
            return parts;
        }
        return new String[]{name};
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return filter.filterCharacters(this.name);
    }
}

