/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor.slot;

import java.io.Serializable;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.util.Preconditions;

public class SlotOffer
implements Serializable {
    private static final long serialVersionUID = -7067814231108250971L;
    private AllocationID allocationId;
    private final int slotIndex;
    private final ResourceProfile resourceProfile;

    public SlotOffer(AllocationID allocationID, int index, ResourceProfile resourceProfile) {
        this.allocationId = Preconditions.checkNotNull(allocationID);
        this.slotIndex = index;
        this.resourceProfile = Preconditions.checkNotNull(resourceProfile);
    }

    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public ResourceProfile getResourceProfile() {
        return this.resourceProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotOffer slotOffer = (SlotOffer)o;
        return this.allocationId.equals(slotOffer.allocationId);
    }

    public int hashCode() {
        return this.allocationId.hashCode();
    }

    public String toString() {
        return "SlotOffer{allocationId=" + this.allocationId + ", slotIndex=" + this.slotIndex + ", resourceProfile=" + this.resourceProfile + '}';
    }
}

