/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.io.Serializable;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointStatsCounts
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointStatsCounts.class);
    private static final long serialVersionUID = -5229425063269482528L;
    private long numRestoredCheckpoints;
    private long numTotalCheckpoints;
    private int numInProgressCheckpoints;
    private long numCompletedCheckpoints;
    private long numFailedCheckpoints;

    CheckpointStatsCounts() {
        this(0L, 0L, 0, 0L, 0L);
    }

    private CheckpointStatsCounts(long numRestoredCheckpoints, long numTotalCheckpoints, int numInProgressCheckpoints, long numCompletedCheckpoints, long numFailedCheckpoints) {
        Preconditions.checkArgument(numRestoredCheckpoints >= 0L, "Negative number of restored checkpoints");
        Preconditions.checkArgument(numTotalCheckpoints >= 0L, "Negative total number of checkpoints");
        Preconditions.checkArgument(numInProgressCheckpoints >= 0, "Negative number of in progress checkpoints");
        Preconditions.checkArgument(numCompletedCheckpoints >= 0L, "Negative number of completed checkpoints");
        Preconditions.checkArgument(numFailedCheckpoints >= 0L, "Negative number of failed checkpoints");
        this.numRestoredCheckpoints = numRestoredCheckpoints;
        this.numTotalCheckpoints = numTotalCheckpoints;
        this.numInProgressCheckpoints = numInProgressCheckpoints;
        this.numCompletedCheckpoints = numCompletedCheckpoints;
        this.numFailedCheckpoints = numFailedCheckpoints;
    }

    public long getNumberOfRestoredCheckpoints() {
        return this.numRestoredCheckpoints;
    }

    public long getTotalNumberOfCheckpoints() {
        return this.numTotalCheckpoints;
    }

    public int getNumberOfInProgressCheckpoints() {
        return this.numInProgressCheckpoints;
    }

    public long getNumberOfCompletedCheckpoints() {
        return this.numCompletedCheckpoints;
    }

    public long getNumberOfFailedCheckpoints() {
        return this.numFailedCheckpoints;
    }

    void incrementRestoredCheckpoints() {
        ++this.numRestoredCheckpoints;
    }

    void incrementInProgressCheckpoints() {
        ++this.numInProgressCheckpoints;
        ++this.numTotalCheckpoints;
    }

    void incrementCompletedCheckpoints() {
        if (this.canDecrementOfInProgressCheckpointsNumber()) {
            --this.numInProgressCheckpoints;
        }
        ++this.numCompletedCheckpoints;
    }

    void incrementFailedCheckpoints() {
        if (this.canDecrementOfInProgressCheckpointsNumber()) {
            --this.numInProgressCheckpoints;
        }
        ++this.numFailedCheckpoints;
    }

    void incrementFailedCheckpointsWithoutInProgress() {
        ++this.numFailedCheckpoints;
        ++this.numTotalCheckpoints;
    }

    CheckpointStatsCounts createSnapshot() {
        return new CheckpointStatsCounts(this.numRestoredCheckpoints, this.numTotalCheckpoints, this.numInProgressCheckpoints, this.numCompletedCheckpoints, this.numFailedCheckpoints);
    }

    private boolean canDecrementOfInProgressCheckpointsNumber() {
        boolean decrementLeadsToNegativeNumber;
        boolean bl = decrementLeadsToNegativeNumber = this.numInProgressCheckpoints - 1 < 0;
        if (decrementLeadsToNegativeNumber) {
            String errorMessage = "Incremented the completed number of checkpoints without incrementing the in progress checkpoints before.";
            LOG.warn(errorMessage);
        }
        return !decrementLeadsToNegativeNumber;
    }
}

