/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.operation;

import java.util.List;
import org.apache.flink.table.store.file.manifest.ManifestEntry;
import org.apache.flink.table.store.file.manifest.ManifestFile;
import org.apache.flink.table.store.file.manifest.ManifestList;
import org.apache.flink.table.store.file.operation.AbstractFileStoreScan;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.predicate.PredicateBuilder;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SnapshotManager;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileStoreScan
extends AbstractFileStoreScan {
    private final FieldStatsArraySerializer keyStatsConverter;
    private final RowType keyType;
    private Predicate keyFilter;

    public KeyValueFileStoreScan(RowType partitionType, RowType bucketKeyType, RowType keyType, SnapshotManager snapshotManager, ManifestFile.Factory manifestFileFactory, ManifestList.Factory manifestListFactory, int numOfBuckets, boolean checkNumOfBuckets) {
        super(partitionType, bucketKeyType, snapshotManager, manifestFileFactory, manifestListFactory, numOfBuckets, checkNumOfBuckets);
        this.keyStatsConverter = new FieldStatsArraySerializer(keyType);
        this.keyType = keyType;
    }

    public KeyValueFileStoreScan withKeyFilter(Predicate predicate) {
        this.keyFilter = predicate;
        List<Predicate> bucketFilters = PredicateBuilder.pickTransformFieldMapping(PredicateBuilder.splitAnd(predicate), this.keyType.getFieldNames(), this.bucketKeyType.getFieldNames());
        if (bucketFilters.size() > 0) {
            this.withBucketKeyFilter(PredicateBuilder.and(bucketFilters));
        }
        return this;
    }

    @Override
    protected boolean filterByStats(ManifestEntry entry) {
        return this.keyFilter == null || this.keyFilter.test(entry.file().rowCount(), entry.file().keyStats().fields(this.keyStatsConverter, entry.file().rowCount()));
    }
}

