/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.hive.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.store.hive.objectinspector.TableStoreObjectInspectorFactory;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

public class TableStoreListObjectInspector
implements ListObjectInspector {
    private final ObjectInspector elementObjectInspector;
    private final ArrayData.ElementGetter elementGetter;

    public TableStoreListObjectInspector(LogicalType elementType) {
        this.elementObjectInspector = TableStoreObjectInspectorFactory.create(elementType);
        this.elementGetter = ArrayData.createElementGetter(elementType);
    }

    public ObjectInspector getListElementObjectInspector() {
        return this.elementObjectInspector;
    }

    public Object getListElement(Object o, int i) {
        if (o == null) {
            return null;
        }
        return this.elementGetter.getElementOrNull((ArrayData)o, i);
    }

    public int getListLength(Object o) {
        if (o == null) {
            return -1;
        }
        return ((ArrayData)o).size();
    }

    public List<?> getList(Object o) {
        if (o == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.getListLength(o); ++i) {
            result.add(this.getListElement(o, i));
        }
        return result;
    }

    public String getTypeName() {
        return "array<" + this.elementObjectInspector.getTypeName() + ">";
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.LIST;
    }
}

