/*
 * Licensed to the Apache Software Foundation (ASF) under one or more contributor license
 * agreements. See the NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The ASF licenses this file to You under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance with the License. You may obtain a
 * copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.distributed.internal.ServerLocation;
import org.apache.geode.internal.cache.tier.sockets.Message;

/**
 * This class provides 'do-nothing' implementations of all of the methods of interface
 * ClientServerObserver. See the documentation for class ClientServerObserverHolder for details.
 *
 * @since GemFire 5.1
 */
public class ClientServerObserverAdapter implements ClientServerObserver {
  /**
   * This callback is called when now primary Ep is identified.
   */
  @Override
  public void afterPrimaryIdentificationFromBackup(ServerLocation primaryEndpoint) {}

  /**
   * This callback is called just before interest registartion
   */
  @Override
  public void beforeInterestRegistration() {}

  /**
   * This callback is called just after interest registartion
   */
  @Override
  public void afterInterestRegistration() {}

  /**
   * This callback is called just before primary identification
   */
  @Override
  public void beforePrimaryIdentificationFromBackup() {}

  /**
   * This callback is called just before Interest Recovery by DSM thread happens
   */
  @Override
  public void beforeInterestRecovery() {

  }

  @Override
  public void beforeFailoverByCacheClientUpdater(ServerLocation epFailed) {}

  /**
   * Invoked before sending an instantiator message to server
   *
   */
  @Override
  public void beforeSendingToServer(EventID eventId) {

  }

  /**
   * Invoked after sending an instantiator message to server
   *
   */
  @Override
  public void afterReceivingFromServer(EventID eventId) {

  }

  /**
   * This callback is called just before sending client ack to the primary servrer.
   */
  @Override
  public void beforeSendingClientAck() {

  }

  /**
   * Invoked after Message is created
   *
   */
  @Override
  public void afterMessageCreation(Message msg) {

  }

  /**
   * Invoked after Queue Destroy Message has been sent
   */
  @Override
  public void afterQueueDestroyMessage() {

  }

  /**
   * Invoked after a primary is recovered from a backup or new connection.
   */
  @Override
  public void afterPrimaryRecovered(ServerLocation location) {}
}
