/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.domain;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Scope;
import org.apache.geode.management.internal.cli.domain.RegionDescriptionPerMember;

public class RegionDescription
implements Serializable {
    private static final long serialVersionUID = 6461449275798378332L;
    private String name;
    private boolean isPartition;
    private boolean isPersistent;
    private boolean isReplicate;
    private boolean isLocal = false;
    private boolean isAccessor = false;
    private Map<String, String> cndRegionAttributes = new HashMap<String, String>();
    private Map<String, String> cndPartitionAttributes = new HashMap<String, String>();
    private Map<String, String> cndEvictionAttributes = new HashMap<String, String>();
    private Map<String, RegionDescriptionPerMember> regionDescPerMemberMap = null;
    private Scope scope;
    private DataPolicy dataPolicy;

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean add(RegionDescriptionPerMember regionDescPerMember) {
        boolean isAdded = false;
        if (this.regionDescPerMemberMap == null) {
            this.regionDescPerMemberMap = new HashMap<String, RegionDescriptionPerMember>();
            this.regionDescPerMemberMap.put(regionDescPerMember.getHostingMember(), regionDescPerMember);
            this.scope = regionDescPerMember.getScope();
            this.dataPolicy = regionDescPerMember.getDataPolicy();
            this.name = regionDescPerMember.getName();
            this.isPartition = this.dataPolicy.withPartitioning();
            this.isPersistent = this.dataPolicy.withPersistence();
            this.isReplicate = this.dataPolicy.withReplication();
            this.isLocal = this.scope.isLocal();
            this.isAccessor = regionDescPerMember.isAccessor();
            this.cndRegionAttributes.putAll(regionDescPerMember.getNonDefaultRegionAttributes());
            this.cndPartitionAttributes.putAll(regionDescPerMember.getNonDefaultPartitionAttributes());
            this.cndEvictionAttributes.putAll(regionDescPerMember.getNonDefaultEvictionAttributes());
            isAdded = true;
        } else if (this.scope.equals(regionDescPerMember.getScope()) && this.name.equals(regionDescPerMember.getName()) && this.dataPolicy.equals(regionDescPerMember.getDataPolicy()) && this.isAccessor == regionDescPerMember.isAccessor()) {
            this.regionDescPerMemberMap.put(regionDescPerMember.getHostingMember(), regionDescPerMember);
            RegionDescription.findCommon(this.cndRegionAttributes, regionDescPerMember.getNonDefaultRegionAttributes());
            RegionDescription.findCommon(this.cndEvictionAttributes, regionDescPerMember.getNonDefaultEvictionAttributes());
            RegionDescription.findCommon(this.cndPartitionAttributes, regionDescPerMember.getNonDefaultPartitionAttributes());
            isAdded = true;
        }
        return isAdded;
    }

    static void findCommon(Map<String, String> commonValuesMap, Map<String, String> additionalValuesMap) {
        Set<String> sharedKeySet = commonValuesMap.keySet();
        sharedKeySet.retainAll(additionalValuesMap.keySet());
        for (String sharedKey : new HashSet<String>(sharedKeySet)) {
            String commonNdValue = commonValuesMap.get(sharedKey);
            String incomingNdValue = additionalValuesMap.get(sharedKey);
            if ((commonNdValue == null || commonNdValue.equals(incomingNdValue)) && (commonNdValue != null || incomingNdValue == null)) continue;
            commonValuesMap.remove(sharedKey);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegionDescription) {
            RegionDescription regionDesc = (RegionDescription)obj;
            return this.getName().equals(regionDesc.getName()) && this.scope.equals(regionDesc.getScope()) && this.dataPolicy.equals(regionDesc.getDataPolicy());
        }
        return true;
    }

    public int hashCode() {
        return 42;
    }

    public Set<String> getHostingMembers() {
        return this.regionDescPerMemberMap.keySet();
    }

    public String getName() {
        return this.name;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public boolean isPartition() {
        return this.isPartition;
    }

    public boolean isReplicate() {
        return this.isReplicate;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public boolean isAccessor() {
        return this.isAccessor;
    }

    public Map<String, String> getCndRegionAttributes() {
        return this.cndRegionAttributes;
    }

    public Map<String, String> getCndEvictionAttributes() {
        return this.cndEvictionAttributes;
    }

    public Map<String, String> getCndPartitionAttributes() {
        return this.cndPartitionAttributes;
    }

    public Map<String, RegionDescriptionPerMember> getRegionDescriptionPerMemberMap() {
        return this.regionDescPerMemberMap;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.regionDescPerMemberMap == null || this.regionDescPerMemberMap.isEmpty();
    }
}

