/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.query.internal.QueryConfigurationService;
import org.apache.geode.cache.query.internal.QueryConfigurationServiceImpl;
import org.apache.geode.cache.query.management.configuration.QueryConfigService;
import org.apache.geode.cache.query.security.MethodInvocationAuthorizer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;

public class DescribeQueryServiceFunction
extends CliFunction {
    private static final long serialVersionUID = 8283480284191516847L;
    static final String QUERY_SERVICE_NOT_FOUND_MESSAGE = "QueryConfigurationService not found on member.";

    public CliFunctionResult executeFunction(FunctionContext context) {
        QueryConfigurationServiceImpl queryConfigurationService = this.getQueryConfigurationService();
        if (queryConfigurationService != null) {
            return new CliFunctionResult(context.getMemberName(), (Object)this.translateQueryServiceObjectIntoQueryConfigService(queryConfigurationService));
        }
        return new CliFunctionResult(context.getMemberName(), CliFunctionResult.StatusState.ERROR, QUERY_SERVICE_NOT_FOUND_MESSAGE);
    }

    QueryConfigurationServiceImpl getQueryConfigurationService() {
        return (QueryConfigurationServiceImpl)((InternalCache)CacheFactory.getAnyInstance()).getService(QueryConfigurationService.class);
    }

    QueryConfigService translateQueryServiceObjectIntoQueryConfigService(QueryConfigurationServiceImpl queryServiceObject) {
        QueryConfigService queryConfigService = new QueryConfigService();
        MethodInvocationAuthorizer methodAuthorizer = queryServiceObject.getMethodAuthorizer();
        if (methodAuthorizer != null) {
            QueryConfigService.MethodAuthorizer methodAuthorizerConfig = new QueryConfigService.MethodAuthorizer();
            methodAuthorizerConfig.setClassName(methodAuthorizer.getClass().getName());
            queryConfigService.setMethodAuthorizer(methodAuthorizerConfig);
        }
        return queryConfigService;
    }
}

