/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.ClassNameType;

public class GatewaySenderFunctionArgs
implements Serializable {
    private static final long serialVersionUID = 4636678328980816780L;
    private final String id;
    private final Integer remoteDSId;
    private final Boolean parallel;
    private final Boolean groupTransactionEvents;
    private final Boolean manualStart;
    private final Integer socketBufferSize;
    private final Integer socketReadTimeout;
    private final Boolean enableBatchConflation;
    private final Integer batchSize;
    private final Integer batchTimeInterval;
    private final Boolean enablePersistence;
    private final String diskStoreName;
    private final Boolean diskSynchronous;
    private final Integer maxQueueMemory;
    private final Integer alertThreshold;
    private final Integer dispatcherThreads;
    private final String orderPolicy;
    private final List<String> gatewayEventFilters;
    private final List<String> gatewayTransportFilters;
    private final Boolean enforceThreadsConnectSameReceiver;

    public GatewaySenderFunctionArgs(CacheConfig.GatewaySender sender) {
        this.id = sender.getId();
        this.remoteDSId = this.string2int(sender.getRemoteDistributedSystemId());
        this.parallel = sender.isParallel();
        this.groupTransactionEvents = sender.mustGroupTransactionEvents();
        this.manualStart = sender.isManualStart();
        this.socketBufferSize = this.string2int(sender.getSocketBufferSize());
        this.socketReadTimeout = this.string2int(sender.getSocketReadTimeout());
        this.enableBatchConflation = sender.isEnableBatchConflation();
        this.batchSize = this.string2int(sender.getBatchSize());
        this.batchTimeInterval = this.string2int(sender.getBatchTimeInterval());
        this.enablePersistence = sender.isEnablePersistence();
        this.diskStoreName = sender.getDiskStoreName();
        this.diskSynchronous = sender.isDiskSynchronous();
        this.maxQueueMemory = this.string2int(sender.getMaximumQueueMemory());
        this.alertThreshold = this.string2int(sender.getAlertThreshold());
        this.dispatcherThreads = this.string2int(sender.getDispatcherThreads());
        this.orderPolicy = sender.getOrderPolicy();
        this.gatewayEventFilters = Optional.of(sender.getGatewayEventFilters()).map(filters -> filters.stream().map(ClassNameType::getClassName).collect(Collectors.toList())).orElse(null);
        this.gatewayTransportFilters = Optional.of(sender.getGatewayTransportFilters()).map(filters -> filters.stream().map(ClassNameType::getClassName).collect(Collectors.toList())).orElse(null);
        this.enforceThreadsConnectSameReceiver = sender.getEnforceThreadsConnectSameReceiver();
    }

    private Integer string2int(String x) {
        return Optional.ofNullable(x).map(Integer::valueOf).orElse(null);
    }

    public String getId() {
        return this.id;
    }

    public Integer getRemoteDistributedSystemId() {
        return this.remoteDSId;
    }

    public Boolean isParallel() {
        return this.parallel;
    }

    public Boolean mustGroupTransactionEvents() {
        return this.groupTransactionEvents;
    }

    public Boolean isManualStart() {
        return this.manualStart;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public Integer getSocketReadTimeout() {
        return this.socketReadTimeout;
    }

    public Boolean isBatchConflationEnabled() {
        return this.enableBatchConflation;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    public Boolean isPersistenceEnabled() {
        return this.enablePersistence;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public Boolean isDiskSynchronous() {
        return this.diskSynchronous;
    }

    public Integer getMaxQueueMemory() {
        return this.maxQueueMemory;
    }

    public Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    public Integer getDispatcherThreads() {
        return this.dispatcherThreads;
    }

    public String getOrderPolicy() {
        return this.orderPolicy;
    }

    public List<String> getGatewayEventFilter() {
        return this.gatewayEventFilters;
    }

    public List<String> getGatewayTransportFilter() {
        return this.gatewayTransportFilters;
    }

    public Boolean getEnforceThreadsConnectSameReceiver() {
        return this.enforceThreadsConnectSameReceiver;
    }
}

