/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalCacheForClientAccess;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.cli.commands.RegionCommandsUtils;
import org.apache.geode.management.internal.cli.functions.CreateRegionFunctionArgs;
import org.apache.geode.management.internal.configuration.domain.XmlEntity;
import org.apache.geode.management.internal.configuration.realizers.RegionConfigRealizer;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.util.RegionPath;
import org.apache.logging.log4j.Logger;

public class RegionCreateFunction
implements InternalFunction {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 8746830191680509335L;
    private static final String ID = RegionCreateFunction.class.getName();
    @Immutable
    public static final RegionCreateFunction INSTANCE = new RegionCreateFunction();
    @Immutable
    private static final RegionConfigRealizer realizer = new RegionConfigRealizer();

    public boolean isHA() {
        return false;
    }

    public void execute(FunctionContext context) {
        ResultSender resultSender = context.getResultSender();
        InternalCacheForClientAccess cache = ((InternalCache)context.getCache()).getCacheForProcessingClientRequests();
        String memberNameOrId = context.getMemberName();
        CreateRegionFunctionArgs regionCreateArgs = (CreateRegionFunctionArgs)context.getArguments();
        try {
            RegionPath regionPath = new RegionPath(regionCreateArgs.getRegionPath());
            this.getRealizer().create(regionCreateArgs.getConfig(), regionCreateArgs.getRegionPath(), (InternalCache)cache);
            XmlEntity xmlEntity = new XmlEntity("region", "name", regionPath.getRootRegionName());
            resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, (Object)xmlEntity.getXmlDefinition(), CliStrings.format((String)"Region \"{0}\" created on \"{1}\"", (Object[])new Object[]{regionCreateArgs.getRegionPath(), memberNameOrId})));
        }
        catch (IllegalStateException e) {
            String exceptionMsg = e.getMessage();
            String localizedString = "Only regions with persistence or overflow to disk can specify DiskStore";
            if (localizedString.equals(e.getMessage())) {
                exceptionMsg = exceptionMsg + " " + CliStrings.format((String)"Use one of these shortcuts: {0}", (Object[])new Object[]{String.valueOf(RegionCommandsUtils.PERSISTENT_OVERFLOW_SHORTCUTS)});
            }
            resultSender.lastResult((Object)this.handleException(memberNameOrId, exceptionMsg, null));
        }
        catch (IllegalArgumentException e) {
            resultSender.lastResult((Object)this.handleException(memberNameOrId, e.getMessage(), e));
        }
        catch (RegionExistsException e) {
            if (regionCreateArgs.isIfNotExists()) {
                resultSender.lastResult((Object)new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.OK, CliStrings.format((String)"Skipping \"{0}\". Region \"{1}\" already exists.", (Object[])new Object[]{memberNameOrId, regionCreateArgs.getRegionPath()})));
            } else {
                String exceptionMsg = CliStrings.format((String)"Region with path \"{0}\" already exists on \"{1}\"", (Object[])new Object[]{regionCreateArgs.getRegionPath(), memberNameOrId});
                resultSender.lastResult((Object)this.handleException(memberNameOrId, exceptionMsg, (Exception)((Object)e)));
            }
        }
        catch (Exception e) {
            String exceptionMsg = e.getMessage();
            if (exceptionMsg == null) {
                exceptionMsg = ExceptionUtils.getStackTrace((Throwable)e);
            }
            resultSender.lastResult((Object)this.handleException(memberNameOrId, exceptionMsg, e));
        }
    }

    private CliFunctionResult handleException(String memberNameOrId, String exceptionMsg, Exception e) {
        if (e != null && logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        if (exceptionMsg != null) {
            return new CliFunctionResult(memberNameOrId, CliFunctionResult.StatusState.ERROR, exceptionMsg);
        }
        return new CliFunctionResult(memberNameOrId, (Object)CliFunctionResult.StatusState.ERROR);
    }

    public String getId() {
        return ID;
    }

    @VisibleForTesting
    protected RegionConfigRealizer getRealizer() {
        return realizer;
    }
}

