/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.SocketException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.Bundler;
import org.jgroups.protocols.TP;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.Util;

public class NoBundler
implements Bundler {
    protected TP transport;
    protected Log log;
    protected int pool_size = 10;
    protected BlockingQueue<ByteArrayDataOutputStream> buf_pool;
    protected int initial_buf_size = 512;

    public NoBundler poolSize(int s) {
        if (s == this.pool_size) {
            return this;
        }
        this.pool_size = s;
        ArrayBlockingQueue<ByteArrayDataOutputStream> new_pool = new ArrayBlockingQueue<ByteArrayDataOutputStream>(this.pool_size);
        BlockingQueue<ByteArrayDataOutputStream> tmp = this.buf_pool;
        this.buf_pool = new_pool;
        if (tmp != null) {
            tmp.clear();
        }
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    public int initialBufSize() {
        return this.initial_buf_size;
    }

    public NoBundler initialBufSize(int s) {
        this.initial_buf_size = s;
        return this;
    }

    public int poolSize() {
        return this.pool_size;
    }

    @Override
    public void viewChange(View view) {
    }

    @Override
    public void init(TP transport) {
        this.transport = transport;
        this.log = transport.getLog();
        this.buf_pool = new ArrayBlockingQueue<ByteArrayDataOutputStream>(this.pool_size);
        for (int i = 0; i < this.pool_size; ++i) {
            this.buf_pool.offer(new ByteArrayDataOutputStream(this.initial_buf_size));
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void send(Message msg) throws Exception {
        ByteArrayDataOutputStream out = null;
        try {
            out = (ByteArrayDataOutputStream)this.buf_pool.poll();
            if (out == null) {
                out = new ByteArrayDataOutputStream(this.initial_buf_size);
                this.log.warn("created new output buffer as pool was empty");
            }
            this.sendSingleMessage(msg, out);
        }
        finally {
            if (out != null) {
                this.buf_pool.offer(out);
            }
        }
    }

    protected void sendSingleMessage(Message msg, ByteArrayDataOutputStream output) {
        Address dest = msg.getDest();
        try {
            output.position(0);
            Util.writeMessage(msg, output, dest == null);
            this.transport.doSend(this.transport.getClusterName(msg), output.buffer(), 0, output.position(), dest);
            if (this.transport.statsEnabled()) {
                this.transport.incrSingleMsgsInsteadOfBatches();
            }
        }
        catch (SocketException sock_ex) {
            this.log.trace(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), sock_ex.toString(), msg.printHeaders());
        }
        catch (Throwable e) {
            this.log.error(Util.getMessage("SendFailure"), this.transport.localAddress(), dest == null ? "cluster" : dest, msg.size(), e.toString(), msg.printHeaders());
        }
    }
}

