/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UNICAST2;
import org.jgroups.protocols.UNICAST3;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class UnicastTest {
    protected JChannel channel;
    protected final MyReceiver receiver = new MyReceiver();
    protected long sleep_time = 0L;
    protected boolean oob = false;
    protected boolean dont_bundle = false;
    protected int num_threads = 1;
    protected int num_msgs = 100000;
    protected int msg_size = 1000;
    protected static final byte START = 1;
    protected static final byte DATA = 2;

    public void init(Protocol[] props, long sleep_time, String name) throws Exception {
        this._init(new JChannel(props), sleep_time, name);
    }

    public void init(String props, long sleep_time, String name) throws Exception {
        this._init(new JChannel(props), sleep_time, name);
    }

    protected void _init(JChannel ch, long sleep_time, String name) throws Exception {
        this.sleep_time = sleep_time;
        this.channel = ch;
        if (name != null) {
            this.channel.setName(name);
        }
        this.channel.connect(this.getClass().getSimpleName());
        this.channel.setReceiver(this.receiver);
        try {
            MBeanServer server = Util.getMBeanServer();
            JmxConfigurator.registerChannel(this.channel, server, "jgroups-" + name, this.channel.getClusterName(), true);
        }
        catch (Throwable ex) {
            System.err.println("registering the channel with JMX failed: " + ex);
        }
    }

    public void eventLoop() throws Exception {
        block13: while (true) {
            System.out.print("[1] Send msgs [2] Print view [3] Print conns [5] Trash all conns\n[6] Set sender threads (" + this.num_threads + ") [7] Set num msgs (" + this.num_msgs + ") [8] Set msg size (" + Util.printBytes(this.msg_size) + ")\n[o] Toggle OOB (" + this.oob + ") [b] Toggle dont_bundle (" + this.dont_bundle + ")\n[q] Quit\n");
            System.out.flush();
            int c = System.in.read();
            switch (c) {
                case -1: {
                    continue block13;
                }
                case 49: {
                    this.sendMessages();
                    continue block13;
                }
                case 50: {
                    this.printView();
                    continue block13;
                }
                case 51: {
                    this.printConnections();
                    continue block13;
                }
                case 53: {
                    this.removeAllConnections();
                    continue block13;
                }
                case 54: {
                    this.setSenderThreads();
                    continue block13;
                }
                case 55: {
                    this.setNumMessages();
                    continue block13;
                }
                case 56: {
                    this.setMessageSize();
                    continue block13;
                }
                case 111: {
                    this.oob = !this.oob;
                    System.out.println("oob=" + this.oob);
                    continue block13;
                }
                case 98: {
                    this.dont_bundle = !this.dont_bundle;
                    System.out.println("dont_bundle = " + this.dont_bundle);
                    continue block13;
                }
                case 113: {
                    this.channel.close();
                    return;
                }
            }
        }
    }

    protected void printConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        if (prot instanceof UNICAST) {
            System.out.println(((UNICAST)prot).printConnections());
        } else if (prot instanceof UNICAST2) {
            System.out.println(((UNICAST2)prot).printConnections());
        } else if (prot instanceof UNICAST3) {
            System.out.println(((UNICAST3)prot).printConnections());
        }
    }

    protected void removeAllConnections() {
        Protocol prot = this.channel.getProtocolStack().findProtocol(Util.getUnicastProtocols());
        if (prot instanceof UNICAST) {
            ((UNICAST)prot).removeAllConnections();
        } else if (prot instanceof UNICAST2) {
            ((UNICAST2)prot).removeAllConnections();
        } else if (prot instanceof UNICAST3) {
            ((UNICAST3)prot).removeAllConnections();
        }
    }

    void sendMessages() throws Exception {
        Address destination = this.getReceiver();
        if (destination == null) {
            System.err.println("UnicastTest.sendMessages(): receiver is null, cannot send messages");
            return;
        }
        if (this.num_threads > 1 && this.num_msgs % this.num_threads != 0) {
            System.err.println("num_msgs (" + this.num_msgs + " ) has to be divisible by num_threads (" + this.num_threads + ")");
            return;
        }
        System.out.println("sending " + this.num_msgs + " messages (" + Util.printBytes(this.msg_size) + ") to " + destination + ": oob=" + this.oob + ", " + this.num_threads + " sender thread(s)");
        ByteBuffer buf = ByteBuffer.allocate(9).put((byte)1).putLong(this.num_msgs);
        Message msg = new Message(destination, buf.array());
        this.channel.send(msg);
        long print = this.num_msgs / 10;
        int msgs_per_sender = this.num_msgs / this.num_threads;
        Sender[] senders = new Sender[this.num_threads];
        for (int i = 0; i < senders.length; ++i) {
            senders[i] = new Sender(msgs_per_sender, this.msg_size, destination, (int)print);
        }
        for (Sender sender : senders) {
            sender.start();
        }
        for (Sender sender : senders) {
            sender.join();
        }
        System.out.println("done sending " + this.num_msgs + " to " + destination);
    }

    void setSenderThreads() throws Exception {
        int threads = Util.readIntFromStdin("Number of sender threads: ");
        int old = this.num_threads;
        this.num_threads = threads;
        System.out.println("sender threads set to " + this.num_threads + " (from " + old + ")");
    }

    void setNumMessages() throws Exception {
        this.num_msgs = Util.readIntFromStdin("Number of messages: ");
        System.out.println("Set num_msgs=" + this.num_msgs);
    }

    void setMessageSize() throws Exception {
        this.msg_size = Util.readIntFromStdin("Message size: ");
        System.out.println("set msg_size=" + this.msg_size);
    }

    void printView() {
        System.out.println("\n-- view: " + this.channel.getView() + '\n');
        try {
            System.in.skip(System.in.available());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Address getReceiver() {
        try {
            List<Address> mbrs = this.channel.getView().getMembers();
            System.out.println("pick receiver from the following members:");
            int i = 0;
            for (Address mbr : mbrs) {
                if (mbr.equals(this.channel.getAddress())) {
                    System.out.println("[" + i + "]: " + mbr + " (self)");
                } else {
                    System.out.println("[" + i + "]: " + mbr);
                }
                ++i;
            }
            System.out.flush();
            System.in.skip(System.in.available());
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String tmp = reader.readLine().trim();
            int index = Integer.parseInt(tmp);
            return mbrs.get(index);
        }
        catch (Exception e) {
            System.err.println("UnicastTest.getReceiver(): " + e);
            return null;
        }
    }

    public static void main(String[] args) {
        long sleep_time = 0L;
        String props = null;
        String name = null;
        for (int i = 0; i < args.length; ++i) {
            if ("-props".equals(args[i])) {
                props = args[++i];
                continue;
            }
            if ("-sleep".equals(args[i])) {
                sleep_time = Long.parseLong(args[++i]);
                continue;
            }
            if ("-name".equals(args[i])) {
                name = args[++i];
                continue;
            }
            UnicastTest.help();
            return;
        }
        try {
            UnicastTest test = new UnicastTest();
            test.init(props, sleep_time, name);
            test.eventLoop();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("UnicastTest [-help] [-props <props>] [-sleep <time in ms between msg sends] [-name name]");
    }

    protected class MyReceiver
    extends ReceiverAdapter {
        protected long start = 0L;
        protected long print;
        protected AtomicLong current_value = new AtomicLong(0L);
        protected AtomicLong total_bytes = new AtomicLong(0L);

        protected MyReceiver() {
        }

        @Override
        public void receive(Message msg) {
            byte[] buf = msg.getRawBuffer();
            byte type = buf[msg.getOffset()];
            switch (type) {
                case 1: {
                    ByteBuffer tmp = ByteBuffer.wrap(buf, 1 + msg.getOffset(), 8);
                    UnicastTest.this.num_msgs = (int)tmp.getLong();
                    this.print = UnicastTest.this.num_msgs / 10;
                    this.current_value.set(0L);
                    this.total_bytes.set(0L);
                    this.start = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    long new_val = this.current_value.incrementAndGet();
                    this.total_bytes.addAndGet(msg.getLength() - 4);
                    if (this.print > 0L && new_val % this.print == 0L) {
                        System.out.println("received " + new_val);
                    }
                    if (new_val < (long)UnicastTest.this.num_msgs) break;
                    long time = System.currentTimeMillis() - this.start;
                    double msgs_sec = (double)this.current_value.get() / ((double)time / 1000.0);
                    double throughput = (double)this.total_bytes.get() / ((double)time / 1000.0);
                    System.out.println(String.format("\nreceived %d messages in %d ms (%.2f msgs/sec), throughput=%s", this.current_value.get(), time, msgs_sec, Util.printBytes(throughput)));
                    break;
                }
                default: {
                    System.err.println("Type " + type + " is invalid");
                }
            }
        }

        @Override
        public void viewAccepted(View new_view) {
            System.out.println("** view: " + new_view);
        }
    }

    protected class Sender
    extends Thread {
        protected final int number_of_msgs;
        protected final Address destination;
        protected final int print;
        protected final byte[] buf;

        public Sender(int num_msgs, int msg_size, Address destination, int print) {
            this.number_of_msgs = num_msgs;
            this.destination = destination;
            this.print = print;
            this.buf = ByteBuffer.allocate(4 + msg_size).put((byte)2).array();
        }

        @Override
        public void run() {
            for (int i = 1; i <= this.number_of_msgs; ++i) {
                try {
                    Message msg = new Message(this.destination, this.buf);
                    if (UnicastTest.this.oob) {
                        msg.setFlag(Message.Flag.OOB);
                    }
                    if (UnicastTest.this.dont_bundle) {
                        msg.setFlag(Message.Flag.DONT_BUNDLE);
                    }
                    if (i > 0 && this.print > 0 && i % this.print == 0) {
                        System.out.println("-- sent " + i);
                    }
                    UnicastTest.this.channel.send(msg);
                    if (UnicastTest.this.sleep_time <= 0L) continue;
                    Util.sleep(UnicastTest.this.sleep_time);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

