/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.executors;

import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LoggingUncaughtExceptionHandler {
    @Immutable
    private static final Implementation handler = new Implementation(LogService.getLogger());

    public static Thread.UncaughtExceptionHandler getInstance() {
        return handler;
    }

    public static void setOnThread(Thread thread) {
        handler.setOnThread(thread);
    }

    public static void setFailureSetter(FailureSetter failureSetter) {
        handler.setFailureSetter(failureSetter);
    }

    public static int getUncaughtExceptionsCount() {
        return handler.getUncaughtExceptionsCount();
    }

    public static void clearUncaughtExceptionsCount() {
        handler.clearUncaughtExceptionsCount();
    }

    LoggingUncaughtExceptionHandler() {
    }

    static class Implementation
    implements Thread.UncaughtExceptionHandler {
        private final Logger logger;
        private FailureSetter failureSetter;
        private final AtomicInteger uncaughtExceptionsCount = new AtomicInteger();

        Implementation(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError && this.failureSetter != null) {
                this.failureSetter.setFailure((VirtualMachineError)e);
            }
            if (e instanceof NoClassDefFoundError && !((LoggingThread)t).isTreatExceptionAsFatal()) {
                this.logger.info("Uncaught exception in thread {} this message can be disregarded if it occurred during an Application Server shutdown. The Exception message was: {}", (Object)t, (Object)e);
            } else {
                String message = MessageFormat.format("Uncaught exception in thread {0}", t);
                this.logger.fatal(message, e);
            }
            this.uncaughtExceptionsCount.incrementAndGet();
        }

        void setFailureSetter(FailureSetter failureSetter) {
            this.failureSetter = failureSetter;
        }

        void setOnThread(Thread thread) {
            thread.setUncaughtExceptionHandler(this);
        }

        int getUncaughtExceptionsCount() {
            return this.uncaughtExceptionsCount.get();
        }

        void clearUncaughtExceptionsCount() {
            this.uncaughtExceptionsCount.set(0);
        }
    }

    public static interface FailureSetter {
        public void setFailure(VirtualMachineError var1);
    }
}

