/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal.cli;

import org.apache.geode.management.internal.cli.GfshParseResult;
import org.apache.geode.management.internal.cli.commands.UsernamePasswordInterceptor;
import org.apache.geode.management.internal.cli.result.model.ResultModel;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class CreateDataSourceInterceptor
extends UsernamePasswordInterceptor {
    static final String POOL_PROPERTIES_ONLY_VALID_ON_POOLED_DATA_SOURCE = "The --pool-properties option is only valid on --pooled data sources.";
    static final String POOLED_DATA_SOURCE_FACTORY_CLASS_ONLY_VALID_ON_POOLED_DATA_SOURCE = "The --pooled-data-source-factory-class option is only valid on --pooled data sources.";

    public CreateDataSourceInterceptor() {
    }

    CreateDataSourceInterceptor(Gfsh gfsh) {
        super(gfsh);
    }

    public ResultModel preExecution(GfshParseResult parseResult) {
        String pooled = parseResult.getParamValueAsString("pooled");
        if (pooled != null && pooled.equalsIgnoreCase("false")) {
            String poolProperties = parseResult.getParamValueAsString("pool-properties");
            if (poolProperties != null && poolProperties.length() > 0) {
                return ResultModel.createError((String)POOL_PROPERTIES_ONLY_VALID_ON_POOLED_DATA_SOURCE);
            }
            String pooledDataSourceFactoryClass = parseResult.getParamValueAsString("pooled-data-source-factory-class");
            if (pooledDataSourceFactoryClass != null && pooledDataSourceFactoryClass.length() > 0) {
                return ResultModel.createError((String)POOLED_DATA_SOURCE_FACTORY_CLASS_ONLY_VALID_ON_POOLED_DATA_SOURCE);
            }
        }
        return super.preExecution(parseResult);
    }
}

