/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal;

import org.apache.geode.cache.PartitionAttributesFactory;
import org.apache.geode.cache.PartitionResolver;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.management.ManagementException;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.cluster.RedisPartitionResolver;

public class RegionProvider {
    public static final String REDIS_DATA_REGION = "__REDIS_DATA";
    public static final String REDIS_CONFIG_REGION = "__REDIS_CONFIG";
    public static final String REDIS_REGION_BUCKETS_PARAM = "redis.region.buckets";
    public static final int REDIS_REGION_BUCKETS = Integer.getInteger("redis.region.buckets", 128);
    public static final int REDIS_SLOTS = 16384;
    public static final int REDIS_SLOTS_PER_BUCKET = 16384 / REDIS_REGION_BUCKETS;
    private final Region<RedisKey, RedisData> dataRegion;
    private final Region<String, Object> configRegion;

    public RegionProvider(InternalCache cache) {
        RegionProvider.validateBucketCount(REDIS_REGION_BUCKETS);
        InternalRegionFactory redisDataRegionFactory = cache.createInternalRegionFactory(RegionShortcut.PARTITION_REDUNDANT);
        redisDataRegionFactory.setInternalRegion(true).setIsUsedForMetaRegion(true);
        PartitionAttributesFactory attributesFactory = new PartitionAttributesFactory();
        attributesFactory.setPartitionResolver((PartitionResolver)new RedisPartitionResolver());
        attributesFactory.setTotalNumBuckets(REDIS_REGION_BUCKETS);
        redisDataRegionFactory.setPartitionAttributes(attributesFactory.create());
        this.dataRegion = redisDataRegionFactory.create(REDIS_DATA_REGION);
        InternalRegionFactory redisConfigRegionFactory = cache.createInternalRegionFactory(RegionShortcut.REPLICATE);
        redisConfigRegionFactory.setInternalRegion(true).setIsUsedForMetaRegion(true);
        this.configRegion = redisConfigRegionFactory.create(REDIS_CONFIG_REGION);
    }

    public Region<RedisKey, RedisData> getDataRegion() {
        return this.dataRegion;
    }

    public Region<String, Object> getConfigRegion() {
        return this.configRegion;
    }

    protected static void validateBucketCount(int buckets) {
        if (buckets > 16384) {
            throw new ManagementException(String.format("Could not start server compatible with Redis - System property '%s' must be <= %d", REDIS_REGION_BUCKETS_PARAM, 16384));
        }
    }
}

