/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.geode.DataSerializer;
import org.apache.geode.InvalidDeltaException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.delta.AddsDeltaInfo;
import org.apache.geode.redis.internal.delta.AppendDeltaInfo;
import org.apache.geode.redis.internal.delta.DeltaInfo;
import org.apache.geode.redis.internal.delta.DeltaType;
import org.apache.geode.redis.internal.delta.RemsDeltaInfo;
import org.apache.geode.redis.internal.delta.TimestampDeltaInfo;

public abstract class AbstractRedisData
implements RedisData {
    private static final BucketRegion.PrimaryMoveReadLockAcquired primaryMoveReadLockAcquired = new BucketRegion.PrimaryMoveReadLockAcquired();
    private static final long NO_EXPIRATION = -1L;
    private volatile long expirationTimestamp = -1L;
    private transient DeltaInfo deltaInfo;

    public String toString() {
        return "expirationTimestamp=" + this.expirationTimestamp;
    }

    @Override
    public void setExpirationTimestamp(Region<RedisKey, RedisData> region, RedisKey key, long value) {
        this.expirationTimestamp = value;
        this.storeChanges(region, key, new TimestampDeltaInfo(value));
    }

    public void setExpirationTimestampNoDelta(long value) {
        this.expirationTimestamp = value;
    }

    @Override
    public int pexpireat(CommandHelper helper, RedisKey key, long timestamp) {
        long now = System.currentTimeMillis();
        if (now >= timestamp) {
            this.doExpiration(helper, key);
        } else {
            this.setExpirationTimestamp(helper.getRegion(), key, timestamp);
        }
        return 1;
    }

    @Override
    public void doExpiration(CommandHelper helper, RedisKey key) {
        long start = helper.getRedisStats().startExpiration();
        helper.getRegion().remove((Object)key);
        helper.getRedisStats().endExpiration(start);
    }

    @Override
    public boolean rename(Region<RedisKey, RedisData> region, RedisKey oldKey, RedisKey newKey) {
        region.put((Object)newKey, (Object)this, (Object)primaryMoveReadLockAcquired);
        try {
            region.destroy((Object)oldKey, (Object)primaryMoveReadLockAcquired);
        }
        catch (EntryNotFoundException entryNotFoundException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    @Override
    public long pttl(Region<RedisKey, RedisData> region, RedisKey key) {
        long expireTimestamp = this.getExpirationTimestamp();
        if (expireTimestamp == -1L) {
            return -1L;
        }
        long now = System.currentTimeMillis();
        if (now >= expireTimestamp) {
            region.remove((Object)key);
            return -2L;
        }
        return expireTimestamp - now;
    }

    @Override
    public int persist(Region<RedisKey, RedisData> region, RedisKey key) {
        if (this.getExpirationTimestamp() == -1L) {
            return 0;
        }
        this.setExpirationTimestamp(region, key, -1L);
        return 1;
    }

    @Override
    public String type() {
        return this.getType().toString();
    }

    public void persistNoDelta() {
        this.setExpirationTimestampNoDelta(-1L);
    }

    @Override
    public boolean hasExpired() {
        long expireTimestamp = this.getExpirationTimestamp();
        if (expireTimestamp == -1L) {
            return false;
        }
        long now = System.currentTimeMillis();
        return now >= expireTimestamp;
    }

    @Override
    public boolean hasExpired(long now) {
        long expireTimestamp = this.getExpirationTimestamp();
        if (expireTimestamp == -1L) {
            return false;
        }
        return now >= expireTimestamp;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeLong(this.expirationTimestamp);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.expirationTimestamp = in.readLong();
    }

    private void setDelta(DeltaInfo deltaInfo) {
        this.deltaInfo = deltaInfo;
    }

    public boolean hasDelta() {
        return this.deltaInfo != null;
    }

    public void toDelta(DataOutput out) throws IOException {
        try {
            this.deltaInfo.serializeTo(out);
        }
        finally {
            this.deltaInfo = null;
        }
    }

    public void fromDelta(DataInput in) throws IOException, InvalidDeltaException {
        DeltaType deltaType = (DeltaType)DataSerializer.readEnum(DeltaType.class, (DataInput)in);
        switch (deltaType) {
            case TIMESTAMP: {
                this.expirationTimestamp = DataSerializer.readLong((DataInput)in);
                break;
            }
            case ADDS: {
                this.applyDelta(new AddsDeltaInfo(this.readArrayList(in)));
                break;
            }
            case REMS: {
                this.applyDelta(new RemsDeltaInfo(this.readArrayList(in)));
                break;
            }
            case APPEND: {
                int sequence = DataSerializer.readPrimitiveInt((DataInput)in);
                byte[] byteArray = DataSerializer.readByteArray((DataInput)in);
                this.applyDelta(new AppendDeltaInfo(byteArray, sequence));
            }
        }
    }

    private ArrayList<ByteArrayWrapper> readArrayList(DataInput in) throws IOException {
        try {
            return DataSerializer.readArrayList((DataInput)in);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void storeChanges(Region<RedisKey, RedisData> region, RedisKey key, DeltaInfo deltaInfo) {
        if (deltaInfo != null) {
            if (this.removeFromRegion()) {
                region.remove((Object)key);
            } else {
                this.setDelta(deltaInfo);
                region.put((Object)key, (Object)this);
            }
        }
    }

    protected abstract void applyDelta(DeltaInfo var1);

    protected abstract boolean removeFromRegion();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRedisData)) {
            return false;
        }
        AbstractRedisData that = (AbstractRedisData)o;
        return this.getExpirationTimestamp() == that.getExpirationTimestamp();
    }

    public int hashCode() {
        return Objects.hash(this.getExpirationTimestamp());
    }
}

