/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisData;
import org.apache.geode.redis.internal.data.RedisHash;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.netty.Coder;

public class NullRedisHash
extends RedisHash {
    NullRedisHash() {
        super(Collections.emptyList());
    }

    @Override
    public boolean isNull() {
        return true;
    }

    @Override
    public int hset(Region<RedisKey, RedisData> region, RedisKey key, List<ByteArrayWrapper> fieldsToSet, boolean nx) {
        region.put((Object)key, (Object)new RedisHash(fieldsToSet));
        return fieldsToSet.size() / 2;
    }

    @Override
    public long hincrby(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper field, long increment) throws NumberFormatException, ArithmeticException {
        region.put((Object)key, (Object)new RedisHash(Arrays.asList(field, new ByteArrayWrapper(Coder.longToBytes(increment)))));
        return increment;
    }

    @Override
    public BigDecimal hincrbyfloat(Region<RedisKey, RedisData> region, RedisKey key, ByteArrayWrapper field, BigDecimal increment) throws NumberFormatException {
        region.put((Object)key, (Object)new RedisHash(Arrays.asList(field, new ByteArrayWrapper(Coder.bigDecimalToBytes(increment)))));
        return increment;
    }
}

