/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.data;

import org.apache.geode.redis.internal.data.CommandHelper;
import org.apache.geode.redis.internal.data.RedisDataCommandsFunctionExecutor;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.key.RedisKeyCommands;

public class RedisKeyCommandsFunctionExecutor
extends RedisDataCommandsFunctionExecutor
implements RedisKeyCommands {
    public RedisKeyCommandsFunctionExecutor(CommandHelper helper) {
        super(helper);
    }

    @Override
    public boolean del(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRegion().remove((Object)key) != null);
    }

    @Override
    public boolean exists(RedisKey key) {
        boolean keyExists = this.stripedExecute(key, () -> this.getRedisData(key).exists());
        if (keyExists) {
            this.helper.getRedisStats().incKeyspaceHits();
        } else {
            this.helper.getRedisStats().incKeyspaceMisses();
        }
        return keyExists;
    }

    @Override
    public long pttl(RedisKey key) {
        long result = this.stripedExecute(key, () -> this.getRedisData(key).pttl(this.getRegion(), key));
        if (result == -2L) {
            this.helper.getRedisStats().incKeyspaceMisses();
        } else {
            this.helper.getRedisStats().incKeyspaceHits();
        }
        return result;
    }

    @Override
    public long internalPttl(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisData(key).pttl(this.getRegion(), key));
    }

    @Override
    public int pexpireat(RedisKey key, long timestamp) {
        return this.stripedExecute(key, () -> this.getRedisData(key).pexpireat(this.helper, key, timestamp));
    }

    @Override
    public int persist(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisData(key).persist(this.getRegion(), key));
    }

    @Override
    public String type(RedisKey key) {
        String type = this.stripedExecute(key, () -> this.getRedisData(key).type());
        if (type.equalsIgnoreCase("none")) {
            this.helper.getRedisStats().incKeyspaceMisses();
        } else {
            this.helper.getRedisStats().incKeyspaceHits();
        }
        return type;
    }

    @Override
    public String internalType(RedisKey key) {
        return this.stripedExecute(key, () -> this.getRedisData(key).type());
    }

    @Override
    public boolean rename(RedisKey oldKey, RedisKey newKey) {
        return this.getRedisData(oldKey).rename(this.getRegion(), oldKey, newKey);
    }
}

