/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.hash;

import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.geode.redis.internal.data.ByteArrayWrapper;
import org.apache.geode.redis.internal.data.RedisKey;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.executor.hash.HashExecutor;
import org.apache.geode.redis.internal.executor.hash.RedisHashCommands;
import org.apache.geode.redis.internal.executor.string.IncrByFloatExecutor;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;

public class HIncrByFloatExecutor
extends HashExecutor {
    private static final int INCREMENT_INDEX = 3;

    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Pair<BigDecimal, RedisResponse> validated = IncrByFloatExecutor.validateIncrByFloatArgument(commandElems.get(3));
        if (validated.getRight() != null) {
            return (RedisResponse)validated.getRight();
        }
        RedisKey key = command.getKey();
        RedisHashCommands redisHashCommands = this.createRedisHashCommands(context);
        byte[] byteField = commandElems.get(2);
        ByteArrayWrapper field = new ByteArrayWrapper(byteField);
        BigDecimal value = redisHashCommands.hincrbyfloat(key, field, (BigDecimal)validated.getLeft());
        return RedisResponse.bigDecimal(value);
    }
}

