/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.pubsub;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import org.apache.geode.redis.internal.executor.AbstractExecutor;
import org.apache.geode.redis.internal.executor.RedisResponse;
import org.apache.geode.redis.internal.netty.Command;
import org.apache.geode.redis.internal.netty.ExecutionHandlerContext;
import org.apache.geode.redis.internal.pubsub.SubscribeResult;

public class SubscribeExecutor
extends AbstractExecutor {
    @Override
    public RedisResponse executeCommand(Command command, ExecutionHandlerContext context) {
        SubscribeResult result;
        Object channelName;
        context.eventLoopReady();
        ArrayList<SubscribeResult> results = new ArrayList<SubscribeResult>();
        for (int i = 1; i < command.getProcessedCommand().size(); ++i) {
            channelName = command.getProcessedCommand().get(i);
            result = context.getPubSub().subscribe((byte[])channelName, context, context.getClient());
            results.add(result);
        }
        ArrayList items = new ArrayList();
        channelName = results.iterator();
        while (channelName.hasNext()) {
            result = (SubscribeResult)channelName.next();
            ArrayList<Object> item = new ArrayList<Object>();
            item.add("subscribe");
            item.add(result.getChannel());
            item.add(result.getChannelCount());
            items.add(item);
        }
        CountDownLatch subscriberLatch = context.getOrCreateEventLoopLatch();
        Runnable callback = () -> {
            Consumer<Boolean> innerCallback = success -> {
                for (SubscribeResult result : results) {
                    if (result.getSubscription() == null) continue;
                    if (success.booleanValue()) {
                        result.getSubscription().readyToPublish();
                        continue;
                    }
                    result.getSubscription().shutdown();
                }
                subscriberLatch.countDown();
            };
            context.changeChannelEventLoopGroup(context.getSubscriberGroup(), innerCallback);
        };
        RedisResponse response = RedisResponse.flattenedArray(items);
        response.setAfterWriteCallback(callback);
        return response;
    }
}

